/* Jim Rees, June 1992 */

#pragma pack(2)

#include <SystemMgr.h>
#include <SerialMgr.h>

#include "output.h"
#include "cc.h"

#define ERSDELAY 1000 /* msec to delay after erase */

struct tiob tiob;

static int bufmode, hflag;
static int mhiy, mloy, mhix, mxtra;

struct {
    char *name;
    int style;
} linepats[] = {
    "dotted",		97,
    "solid",		96,
    "longdashed",	100,
    "shortdashed",	99,
    "dotdashed",	98,
    NULL,		0,
};

tiosetup(hfl)
int hfl;
{
    SerSettingsType settings;

    if (SysLibFind("Serial Library", &tiob.fd))
	return;
    if (SerOpen(tiob.fd, 0, 9600L))
	return;

    SerGetSettings(tiob.fd, &settings);

    settings.flags = (serSettingsFlagStopBits1
		    | serSettingsFlagParityOnM
		    | serSettingsFlagParityEvenM
		    | serSettingsFlagRTSAutoM
		    | serSettingsFlagBitsPerChar7);

    SerSetSettings(tiob.fd, &settings);

    tiob.ptr = tiob.buf;
    tiob.count = TBUFSIZE;
    hflag = hfl;
}

tioclose()
{
    move(0, 3071);
    tputc(US);
    tflush();
    SerClose(tiob.fd);
}

tflushbuf(c)
int c;
{
    *tiob.ptr++ = c;
    tflush();
    return c;
}

tflush()
{
    int n = tiob.ptr - tiob.buf;
    Err err;

    if (n) {
	SerSend(tiob.fd, tiob.buf, n, &err);
	if (err == serErrLineErr)
	    SerReceiveFlush(tiob.fd, 1);
	else if (!err)
	    SerSendWait(tiob.fd, -1);
    }

    tiob.ptr = tiob.buf;
    tiob.count = TBUFSIZE;
}

teksetbuf(mode)
int mode;
{
    bufmode = mode;
}

clear()
{
    setlinepat("solid");
    tputc(ESC);
    tputc(FF);
    tflush();
    SysTaskDelay((long) ERSDELAY * SysTicksPerSecond() / 1000L);
    mhiy = mloy = mhix = mxtra = -1;
}

move(x, y)
int x, y;
{
    tputc(GS);
    tputxy(x, y);
}

draw(x, y)
int x, y;
{
    tputxy(x, y);
    if (bufmode)
	tflush();
}

puttext(s)
char *s;
{
    tputc(US);
    while (*s)
	tputc(*s++);
}

tputxy(x, y)
int x, y;
{
    int hiy, loy, hix, lox, xtra;

    if (hflag)
	xtra = (x & 0x3) | ((y & 0x3) << 2) | 0x60;

    y >>= 2;
    loy = (y & 0x1f) | 96;
    y >>= 5;
    hiy = (y & 0x1f) | 32;

    x >>= 2;
    lox = (x & 0x1f) | 64;
    x >>= 5;
    hix = (x & 0x1f) | 32;

    if (hiy != mhiy) {
	tputc(hiy);
	mhiy = hiy;
    }
    if (loy != mloy || hix != mhix || (hflag && xtra != mxtra)) {
	if (hflag && xtra != mxtra) {
	    tputc(xtra);
	    mxtra = xtra;
	}
	tputc(loy);
	mloy = loy;
    }
    if (hix != mhix) {
	tputc(hix);
	mhix = hix;
    }
    tputc(lox);
}

setlinepat(patname)
char *patname;
{
    int i;

    for (i = 0; linepats[i].name != NULL; i++)
	if (!strcmp(patname, linepats[i].name))
	    break;
    if (linepats[i].name != NULL) {
	tputc(ESC);
	tputc(linepats[i].style);
    }
}

/*
copyright 1999
the regents of the university of michigan
all rights reserved

permission is granted to use, copy, create derivative works
and redistribute this software and such derivative works
for any purpose, so long as the name of the university of
michigan is not used in any advertising or publicity
pertaining to the use or distribution of this software
without specific, written prior authorization.  if the
above copyright notice or any other identification of the
university of michigan is included in any copy of any
portion of this software, then the disclaimer below must
also be included.

this software is provided as is, without representation
from the university of michigan as to its fitness for any
purpose, and without warranty by the university of
michigan of any kind, either express or implied, including
without limitation the implied warranties of
merchantability and fitness for a particular purpose. the
regents of the university of michigan shall not be liable
for any damages, including special, indirect, incidental, or
consequential damages, with respect to any claim arising
out of or in connection with the use of the software, even
if it has been or is hereafter advised of the possibility of
such damages.
*/
