/*
 * Simple http (web) server.
 * Jim Rees University of Michigan
 * Robin Kirkman
 * Original version April 1998
 */

#pragma pack(2)

#if (__GNUC_MINOR__ > 7)
#include <PalmOS.h>
#else
#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>
#endif
#include <System/DataMgr.h>

#include <System/Unix/unix_stdio.h>
#include <System/Unix/unix_stdlib.h>
#include <System/Unix/unix_string.h>

#include "httpd.h"

#define NCATS 16

void get_memo_title(char *mp, char *title);

int send_memo_index(XFILE *f, char *url)
{
    int cat;
    UInt16 n, oldn;
    DmOpenRef MemoDB;
    char title[42], *mp, catname[dmCategoryLength], *u, ub[80];
    void *hp;

    MemoDB = DmOpenDatabaseByTypeCreator('DATA', 'memo', dmModeReadOnly);
    if (!MemoDB) {
	send_404(f, "/memo/");
	return -1;
    }

    wrstr(f, html0, "text/html");
    wrstr(f, "<title>Directory listing for /memo/%s</title><h1>Directory listing for /memo/%s</h1>\n", url, url);

    for (cat = n = 0; cat < NCATS; ) {
	oldn = n;
	hp = DmQueryNextInCategory(MemoDB, &n, cat);
	if (!hp) {
	    if (n)
		xputs(f, "<p>\n");
	    n = 0;
	    cat++;
	    continue;
	}
	if (oldn == 0) {
	    CategoryGetName(MemoDB, cat, catname);
	    wrstr(f, "<b>Files in category <i>%s</i>:</b><p>\n", catname);
	}

	mp = (char *) MemHandleLock(hp);

	get_memo_title(mp, title);

	MemPtrUnlock((void *) mp);

	if (!strncmp(title, url, strlen(url)) || strlen(url)==0) {
	    mp = title + strlen(url);
	    while (*mp && *mp != '/')
		mp++;

	    strcpy(ub,title);
	    u=ub;
	  
	    while (*++u)
		*u=(*u==' ')?'+':*u;
	    u=ub+strlen(url);
	    while (*u && *u != '/')
		++u;
	    if (*mp == '/') {
		*++mp=0;
		*++u=0;
	    }
	    wrstr(f, "<a href=\"/memo/%s\">%s</a><br>\n", ub, title+strlen(url));
#ifdef DEBUG
	} else {
	    wrstr(f, "Rejected file |%s| for url |%s|<br>\n",title,url);
#endif
	}
	n++;
    }
    DmCloseDatabase(MemoDB);
    xputs(f, html_go_home);
    return 0;
}

static char plaintype[] = "text/plain";

int send_memo_file(XFILE *f, char *url, int flags)
{
    int cat;
    DmOpenRef MemoDB;
    char doctype[20], *cp, title[80], *mp, mext[20], mtype[40];
    void *hp=0, *chp=0, *mime=0;
    UInt16 n, oldn, i;

    mp = url;
    while (*mp)
	mp++;
    mp--;
    if (*mp == '/') {
	/* Need a directory; first look for index.html */
	sprintf(title, "%sindex.html", url);
	if (!send_memo_file(f, title, 1))
	    return 0;

	/* No index.html, so send index */
	return send_memo_index(f, url);
    }

    MemoDB = DmOpenDatabaseByTypeCreator('DATA', 'memo', dmModeReadOnly);
    if (!MemoDB)
	goto notfound;

    for (cat = n = 0; cat < NCATS; ) {
	oldn = n;
	hp = DmQueryNextInCategory(MemoDB, &n, cat);
	if (!hp) {
	    n = 0;
	    cat++;
	    continue;
	}

	mp = (char *) MemHandleLock(hp);

	get_memo_title(mp, title);

	if (!strcmp(url, title))
	    chp = hp;

	MemPtrUnlock((void *) mp);

	if (!strcmp(title,"MIME_TYPES.HTTPD"))
	    mime = hp;

	n++;
    }


    hp = chp;

    if (!hp)
	goto notfound;

    /* mime type info is encoded in the url for now */

    mp = cp = (char *) MemHandleLock(hp);

    for (i = 0; *cp && *cp != '\n' && *cp != '\r' && i<40; i++)
	++cp;

    if (mime == NULL) {
	/* Hardcoded types, if we can't find the mime file... */
	if (!strncmp(cp-5,".html",5))
	    strcpy(doctype, "text/html");
	else
	    strcpy(doctype, plaintype);
    } else {
	/* This is the good stuff... */
	char *mf,*mti;
#ifdef DEBUG
	printf("Using MIME file...\n");
#endif
	mti=mf=MemHandleLock(mime);
	while(*mf++!='\n');
	strcpy(doctype, plaintype); /* Default type... */
	while(sscanf(mf,"%s\t%s\n",mext,mtype)==2) {
#ifdef DEBUG
	    printf("%s -> %s (%s)\n",mext,mtype);
#endif
	    if(!strncmp(cp-strlen(mext),mext,strlen(mext))) {
		strcpy(doctype, mtype);
#ifdef DEBUG
		printf("Match!\n");
#endif
	    }
	    while(*mf++!='\n');
	}
	MemPtrUnlock((void *) mti);
    }

    wrstr(f, html0, doctype);

    /* If it's not plain text, don't send the file name */
    if (!strcmp(doctype, plaintype))
	cp = mp;
    else
	cp++;

    xputs(f, cp);

    MemPtrUnlock((void *) mp);
    xputs(f, "\n");
    DmCloseDatabase(MemoDB);
    return 0;

 notfound:
    if (MemoDB)
	DmCloseDatabase(MemoDB);
    if (!(flags & 0x1)) {
	sprintf(title, "/memo/%s", url);
	send_404(f, title);
    }
    return -1;
}

void
get_memo_title(char *mp, char *title)
{
    char *cp0, *cp1;

    /* copy memo title, first line or up to 40 chars */
    for (cp0 = mp, cp1 = title; *cp0 && *cp0 != '\n' && *cp0 != '\r' && cp0 - mp < 40; )
	*cp1++ = *cp0++;
    *cp1 = '\0';
}

/*
copyright 1998, 2000
the regents of the university of michigan
all rights reserved

permission is granted to use, copy, create derivative works
and redistribute this software and such derivative works
for any purpose, so long as the name of the university of
michigan is not used in any advertising or publicity
pertaining to the use or distribution of this software
without specific, written prior authorization.  if the
above copyright notice or any other identification of the
university of michigan is included in any copy of any
portion of this software, then the disclaimer below must
also be included.

this software is provided as is, without representation
from the university of michigan as to its fitness for any
purpose, and without warranty by the university of
michigan of any kind, either express or implied, including
without limitation the implied warranties of
merchantability and fitness for a particular purpose. the
regents of the university of michigan shall not be liable
for any damages, including special, indirect, incidental, or
consequential damages, with respect to any claim arising
out of or in connection with the use of the software, even
if it has been or is hereafter advised of the possibility of
such damages.
*/
