/*
 * This is just like stdio, only different
 *
 * Jim Rees, University of Michigan, March 1999
 */

#ifndef NULL
#define NULL 0
#endif

#ifndef USE_STDIO
#define XBUFSIZ 512

typedef struct xfile {
    int fd, n;
    char *base, *p;
} XFILE;

XFILE *xfdopen(int fd, char *mode);
int xclose(XFILE *f);
int xgets(XFILE *f, char *bp, int n);
int xwrite(XFILE *f, char *bp, int n);
int xputs(XFILE *f, char *bp);
int xflush(XFILE *f);
int xfillbuf(XFILE *f);
#else
#define XFILE FILE
#define xfdopen(fd, mode) fdopen(fd, mode)
#define xclose(f) fclose(f)
#define xgets(f, bp, n) fgets(bp, n, f)
#define xwrite(f, bp, n) fwrite(bp, n, 1, f)
#define xputs(f, bp) fputs(bp, f)
#define xflush(f) fflush(f)
#endif
