/*
 * This is just like stdio, only different
 *
 * Jim Rees, University of Michigan, March 1999
 */

#include "xio.h"

#ifdef __palmos__
#if (__GNUC_MINOR__ > 7)
#include <PalmOS.h>
#else
#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>
#endif
#include <System/MemoryMgr.h>
#include <System/SysEvtMgr.h>
#include <System/Unix/sys_socket.h>
#include <System/Unix/unix_stdlib.h>
#else
#include <stdlib.h>
#include <string.h>
#endif

XFILE _io[2];

#ifdef TEST
#undef XBUFSIZ
#define XBUFSIZ 8
main()
{
    XFILE *f0 = xfdopen(0, "r");
    XFILE *f1 = xfdopen(1, "w");
    char buf[100];

    while (xgets(f0, buf, sizeof buf) >= 0) {
	xputs(f1, buf);
	xflush(f1);
    }
    xclose(f0);
    xclose(f1);
    exit(0);
}
#endif

XFILE *
xfdopen(int fd, char *mode)
{
    XFILE *f;

    f = &_io[(mode[0] != 'w') ? 0 : 1];
    f->fd = fd;
    if (!f->base)
	f->base = malloc(XBUFSIZ);
    f->p = f->base;
    f->n = 0;
    return f;
}

int
xclose(XFILE *f)
{
    xflush(f);
    f->fd = -1;
    free(f->base);
    f->base = NULL;
    return 0;
}

int
xgets(XFILE *f, char *bp, int n)
{
    char *s;

    if (n <= 0)
	return -1;
    s = bp;
    n--;
    while (n > 0) {
	if (f->n <= 0) {
	    if (xfillbuf(f) < 0) {
		if (s == bp)
		    return -1;
		break;
	    }
	}
	while (f->n > 0 && n > 0 && *f->p) {
	    if (*f->p == '\n')
		n = 1;
	    *s++ = *f->p++;
	    f->n--;
	    n--;
	}
    }
    *s = '\0';
    return 0;
}

int
xwrite(XFILE *f, char *bp, int n)
{
    int fn, len;

    f->n = -1;
    while (n > 0) {
	fn = f->base + XBUFSIZ - f->p;
	len = (fn < n) ? fn : n;
	memcpy(f->p, bp, len);
	bp += len;
	f->p += len;
	n -= len;
	if (n > 0 && xflush(f) < 0)
	    return -1;
    }
    return 0;
}

int
xputs(XFILE *f, char *bp)
{
    return xwrite(f, bp, strlen(bp));
}

int
xflush(XFILE *f)
{
    int n, nw;
    char *p;

    p = f->base;
    if (!p)
	return 0;
    n = f->p - p;
    f->p = p;
    if (f->n >= 0) {
	/* read mode stream */
	f->n = 0;
	return 0;
    }
    while (n > 0) {
	nw = write(f->fd, p, n);
	if (nw <= 0)
	    return -1;
	n -= nw;
	p += nw;
    }
    return 0;
}

int
xfillbuf(XFILE *f)
{
    f->p = f->base;
#ifdef __palmos__
    while (1) {
	f->n = read(f->fd, f->p, XBUFSIZ);
	if (f->n >= 0 || errno != netErrTimeout || EvtSysEventAvail(true))
	    break;
    }
#else
    f->n = read(f->fd, f->p, XBUFSIZ);
#endif
    if (f->n <= 0) {
	f->n = 0;
	return -1;
    }
    return 0;
}
