#pragma pack(2)

#if (__GNUC_MINOR__ > 7)
#include <PalmOS.h>
#else
#include <Common.h>
#include <System/SysAll.h>
#endif
#include <System/NetMgr.h>
#include <UI/UIAll.h>

#include "field.h"

char *errtab[] = {
    "AlreadyOpen",
    "NotOpen",
    "StillOpen",
    "ParamErr",
    "NoMoreSockets",
    "OutOfResources",
    "OutOfMemory",
    "SocketNotOpen",
    "SocketBusy",
    "MessageTooBig",
    "SocketNotConnected ",
    "NoInterfaces",
    "BufTooSmall",
    "Unimplemented",
    "PortInUse",
    "QuietTimeNotElapsed",
    "Internal",
    "Timeout",
    "SocketAlreadyConnected ",
    "SocketClosedByRemote ",
    "OutOfCmdBlocks",
    "WrongSocketType",
    "SocketNotListening",
    "UnknownSetting",
    "InvalidSettingSize",
    "PrefNotFound",
    "InvalidInterface",
    "InterfaceNotFound",
    "TooManyInterfaces",
    "BufWrongSize",
    "UserCancel",
    "BadScript",
    "NoSocket",
    "SocketRcvBufFull",
    "NoPendingConnect",
    "UnexpectedCmd",
    "NoTCB",
    "NilRemoteWindowSize",
    "NoTimerProc",
    "SocketInputShutdown",
    "CmdBlockNotCheckedOut",
    "CmdNotDone",
    "UnknownProtocol",
    "UnknownService",
    "UnreachableDest",
    "ReadOnlySetting",
    "WouldBlock",
    "AlreadyInProgress",
    "PPPTimeout",
    "PPPBroughtDown",
    "AuthFailure",
    "PPPAddressRefused",
    "DNSNameTooLong",
    "DNSBadName",
    "DNSBadArgs",
    "DNSLabelTooLong",
    "DNSAllocationFailure",
    "DNSTimeout",
    "DNSUnreachable",
    "DNSFormat",
    "DNSServerFailure",
    "DNSNonexistantName",
    "DNSNIY",
    "DNSRefused",
    "DNSImpossible",
    "DNSNoRRS",
    "DNSAborted",
    "DNSBadProtocol",
    "DNSTruncated",
    "DNSNoRecursion",
    "DNSIrrelevant",
    "DNSNotInLocalCache",
    "DNSNoPort",
    "IPCantFragment",
    "IPNoRoute",
    "IPNoSrc",
    "IPNoDst",
    "IPktOverflow",
    "TooManyTCPConnections",
    "NoDNSServers",
};

char *
geterr(int err)
{
    static char buf[12];

    int cl = (err & 0xff00), er = (err & 0xff);

    if (cl == netErrorClass && er <= 80)
	return errtab[er-1];
    sprintf(buf, "0x%x", err);
    return buf;
}

/*
copyright 2001
the regents of the university of michigan
all rights reserved

permission is granted to use, copy, create derivative works
and redistribute this software and such derivative works
for any purpose, so long as the name of the university of
michigan is not used in any advertising or publicity
pertaining to the use or distribution of this software
without specific, written prior authorization.  if the
above copyright notice or any other identification of the
university of michigan is included in any copy of any
portion of this software, then the disclaimer below must
also be included.

this software is provided as is, without representation
from the university of michigan as to its fitness for any
purpose, and without warranty by the university of
michigan of any kind, either express or implied, including
without limitation the implied warranties of
merchantability and fitness for a particular purpose. the
regents of the university of michigan shall not be liable
for any damages, including special, indirect, incidental, or
consequential damages, with respect to any claim arising
out of or in connection with the use of the software, even
if it has been or is hereafter advised of the possibility of
such damages.
*/
