/*
 * Simple http (web) server.
 * Jim Rees University of Michigan April 1998
 */

typedef struct {
    unsigned when:1;
    unsigned alarm:1;
    unsigned repeat:1;
    unsigned note:1;
    unsigned exceptions:1;
    unsigned description:1;
} ApptDBRecordFlags;

typedef struct {
    TimeType startTime;
    TimeType endTime;
    DateType date;
} ApptDateTimeType;
typedef enum alarmTypes {aauMinutes, aauHours, aauDays} AlarmUnitType;

typedef struct {
    char advance;
    AlarmUnitType advanceUnit;
} AlarmInfoType;

enum repeatTypes {
    repeatNone, 
    repeatDaily, 
    repeatWeekly, 
    repeatMonthlyByDay, 
    repeatMonthlyByDate,
    repeatYearly
};
typedef enum repeatTypes RepeatType;

typedef struct {
    RepeatType repeatType;
    DateType repeatEndDate;
    unsigned char repeatFrequency;
    unsigned char repeatOn;
    unsigned char repeatStartOfWeek;
} RepeatInfoType;

typedef struct {
    UInt16 numExceptions;
    DateType exception;
} ExceptionsListType;

typedef struct {
    ApptDateTimeType when;
    ApptDBRecordFlags flags;
} ApptDBRecordType;
