/*
 * Simple http (web) server.
 * Jim Rees University of Michigan April 1998
 */

#pragma pack(2)

#if (__GNUC_MINOR__ > 7)
#include <PalmOS.h>
#else
#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>
#endif
#include <System/DataMgr.h>
#include <System/DateTime.h>

#include <System/Unix/unix_stdio.h>
#include <System/Unix/unix_stdlib.h>
#include <System/Unix/unix_string.h>

#include "httpd.h"
#include "date.h"

static char appname[] = "Datebook";

static char monthname[][4] = {
    "Jan", "Feb", "Mar", "Apr", "May", "Jun",
    "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
};

int send_date_index(XFILE *f)
{
    int n, nrec;
    DmOpenRef DateDB;
    void *hp;
    ApptDBRecordType *ap;
    char *cp, *desc;

    DateDB = DmOpenDatabaseByTypeCreator('DATA', 'date', dmModeReadOnly);
    if (!DateDB) {
	send_404(f, "/date/");
	return -1;
    }
    nrec = DmNumRecords(DateDB);

    wrstr(f, html0, "text/html");
    wrstr(f, "<title>%s</title>\n<h1>%s</h1>\n", appname, appname);

    for (n = 0; n < nrec; n++) {
	hp = DmQueryRecord(DateDB, n);
	if (!hp)
	    continue;

	cp = (char *) MemHandleLock(hp);
	ap = (ApptDBRecordType *) cp;
	cp += sizeof (ApptDBRecordType);
	if (ap->flags.alarm)
	    cp += sizeof (AlarmInfoType);
	if (ap->flags.repeat)
	    cp += sizeof (RepeatInfoType);
	if (ap->flags.exceptions)
	    cp += sizeof (ExceptionsListType);
	desc = cp;

	wrstr(f, "%d-%s-%02d",
	      ap->when.date.year + 1904,
	      monthname[ap->when.date.month - 1],
	      ap->when.date.day);
	if (ap->when.startTime.hours != 255)
	    wrstr(f, " %2d:%02d", ap->when.startTime.hours, ap->when.startTime.minutes);
	if (ap->flags.description)
	    wrstr(f, " %s", desc);
	if (ap->flags.note)
	    wrstr(f, " <a href=\"/date/%d\">note</a>", n);
	xputs(f, "<br>\n");

	MemHandleUnlock(hp);
    }

    DmCloseDatabase(DateDB);
    xputs(f, "<p>\n");
    xputs(f, html_go_home);
    return 0;
}

int send_date_file(XFILE *f, char *url)
{
    int n;
    DmOpenRef DateDB;
    void *hp = NULL;
    ApptDBRecordType *ap;
    char *cp, *note, *desc;

    if (!strcmp(url, "/date/"))
	return send_date_index(f);

    DateDB = DmOpenDatabaseByTypeCreator('DATA', 'date', dmModeReadOnly);
    if (!DateDB)
	goto notfound;

    if (sscanf(url, "/date/%d", &n) != 1)
	goto notfound;

    hp = DmQueryRecord(DateDB, n);
    if (!hp)
	goto notfound;

    cp = (char *) MemHandleLock(hp);
    ap = (ApptDBRecordType *) cp;
    cp += sizeof (ApptDBRecordType);
    if (ap->flags.alarm)
	cp += sizeof (AlarmInfoType);
    if (ap->flags.repeat)
	cp += sizeof (RepeatInfoType);
    if (ap->flags.exceptions)
	cp += sizeof (ExceptionsListType);
    desc = cp;
    cp += strlen(desc) + 1;
    note = cp;

    if (!ap->flags.note)
	goto notfound;

    wrstr(f, html0, "text/plain");
    xputs(f, note);
    MemPtrUnlock((void *) ap);
    xputs(f, "\n");
    DmCloseDatabase(DateDB);
    return 0;

 notfound:
    if (hp)
	MemHandleUnlock(hp);
    if (DateDB)
	DmCloseDatabase(DateDB);
    send_404(f, url);
    return -1;
}

/*
copyright 1998
the regents of the university of michigan
all rights reserved

permission is granted to use, copy, create derivative works
and redistribute this software and such derivative works
for any purpose, so long as the name of the university of
michigan is not used in any advertising or publicity
pertaining to the use or distribution of this software
without specific, written prior authorization.  if the
above copyright notice or any other identification of the
university of michigan is included in any copy of any
portion of this software, then the disclaimer below must
also be included.

this software is provided as is, without representation
from the university of michigan as to its fitness for any
purpose, and without warranty by the university of
michigan of any kind, either express or implied, including
without limitation the implied warranties of
merchantability and fitness for a particular purpose. the
regents of the university of michigan shall not be liable
for any damages, including special, indirect, incidental, or
consequential damages, with respect to any claim arising
out of or in connection with the use of the software, even
if it has been or is hereafter advised of the possibility of
such damages.
*/
