/*
 * Simple http (web) server.
 * Jim Rees University of Michigan July 2000
 */

#pragma pack(2)

#if (__GNUC_MINOR__ > 7)
#include <PalmOS.h>
#else
#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>
#endif
#include <System/DataMgr.h>
#include <System/DateTime.h>

#include <System/Unix/unix_stdio.h>
#include <System/Unix/unix_stdlib.h>
#include <System/Unix/unix_string.h>

#include "httpd.h"

/* Field bits */
#define AFlast		0
#define AFfirst		1
#define AFcompany	2
#define AFwork		3
#define AFhome		4
#define AFfax		5
#define AFother		6
#define AFemail		7
#define AFaddress	8
#define AFcity		9
#define AFstate		10
#define AFzip		11
#define AFcountry	12
#define AFtitle		13
#define AFc1		14
#define AFc2		15
#define AFc3		16
#define AFc4		17
#define AFnote		18

static char appname[] = "Address Book";

struct addr {
    unsigned long p, f;
    char s[1000];
};

int send_addr_entry(DmOpenRef AddrDB, XFILE *f, int n, int verbose);

int
send_addr_index(XFILE *f)
{
    int nrec, n;
    DmOpenRef AddrDB;

    AddrDB = DmOpenDatabaseByTypeCreator('DATA', 'addr', dmModeReadOnly);
    if (!AddrDB) {
	send_404(f, "/addr/");
	return -1;
    }
    nrec = DmNumRecords(AddrDB);

    wrstr(f, html0, "text/html");
    wrstr(f, "<title>%s</title>\n<h1>%s</h1>\n", appname, appname);

    for (n = 0; n < nrec; n++)
	send_addr_entry(AddrDB, f, n, 0);

    DmCloseDatabase(AddrDB);
    xputs(f, "<p>\n");
    xputs(f, html_go_home);
    return 0;
}

int
send_addr_file(XFILE *f, char *url)
{
    int n;

    if (!strcmp(url, "/addr/"))
	return send_addr_index(f);
    if (sscanf(url, "/addr/%d", &n) != 1) {
	send_404(f, url);
	return -1;
    }
    wrstr(f, html0, "text/plain");
    return send_addr_entry(NULL, f, n, 1);
}

int
send_addr_entry(DmOpenRef AddrDB, XFILE *f, int n, int verbose)
{
    DmOpenRef closeme = NULL;
    int i, r = 0;
    void *hp;
    struct addr *ap;
    char *cp, *d[19];

    if (!AddrDB) {
	AddrDB = closeme = DmOpenDatabaseByTypeCreator('DATA', 'addr', dmModeReadOnly);
	if (!AddrDB)
	    return -1;
    }

    hp = DmQueryRecord(AddrDB, n);
    if (!hp) {
	r = -1;
	goto out;
    }

    ap = (struct addr *) MemHandleLock(hp);
    cp = ap->s + 1;

    for (i = 0; i < 19; i++) {
	if (ap->f & (1L << i)) {
	    d[i] = cp;
	    cp += strlen(cp) + 1;
	} else
	    d[i] = NULL;
    }

    if (!verbose) {
	/* Name */
	wrstr(f, "<a href=\"%d\">", n);
	if (d[AFfirst])
	    wrstr(f, "%s ", d[AFfirst]);
	if (d[AFlast])
	    wrstr(f, "%s", d[AFlast]);
	wrstr(f, "</a><br>\n");
	goto out;
    }

    /* Name, title, company */
    if (d[AFfirst])
	wrstr(f, "%s", d[AFfirst]);
    if (d[AFlast]) {
	if (d[AFfirst])
	    wrstr(f, " ");
	wrstr(f, "%s", d[AFlast]);
    }
    wrstr(f, "\n");

    if (d[AFtitle])
	wrstr(f, "%s\n", d[AFtitle]);
    if (d[AFcompany])
	wrstr(f, "%s\n", d[AFcompany]);

    /* Address */
    if (d[AFaddress])
	wrstr(f, "%s\n", d[AFaddress]);
    if (d[AFcity])
	wrstr(f, "%s", d[AFcity]);
    if (d[AFstate]) {
	if (d[AFcity])
	    wrstr(f, ", ");
	wrstr(f, "%s", d[AFstate]);
    }
    if (d[AFzip]) {
	if (d[AFcity] || d[AFstate])
	    wrstr(f, " ");
	wrstr(f, "%s", d[AFzip]);
    }
    if (d[AFcountry]) {
	if (d[AFcity] || d[AFstate] || d[AFzip])
	    wrstr(f, " ");
	wrstr(f, "%s", d[AFcountry]);
    }
    if (d[AFcity] || d[AFstate] || d[AFzip] || d[AFcountry])
	wrstr(f, "\n");

    /* Phone */
    if (d[AFhome])
	wrstr(f, "Home: %s\n", d[AFhome]);
    if (d[AFwork])
	wrstr(f, "Work: %s\n", d[AFwork]);
    if (d[AFemail])
	wrstr(f, "%s\n", d[AFemail]);

    /* Note */
    if (d[AFnote])
	wrstr(f, "\n%s\n", d[AFnote]);

 out:
    if (closeme)
	DmCloseDatabase(closeme);
    if (hp)
	MemHandleUnlock(hp);
    return r;
}

/*
copyright 1998
the regents of the university of michigan
all rights reserved

permission is granted to use, copy, create derivative works
and redistribute this software and such derivative works
for any purpose, so long as the name of the university of
michigan is not used in any advertising or publicity
pertaining to the use or distribution of this software
without specific, written prior authorization.  if the
above copyright notice or any other identification of the
university of michigan is included in any copy of any
portion of this software, then the disclaimer below must
also be included.

this software is provided as is, without representation
from the university of michigan as to its fitness for any
purpose, and without warranty by the university of
michigan of any kind, either express or implied, including
without limitation the implied warranties of
merchantability and fitness for a particular purpose. the
regents of the university of michigan shall not be liable
for any damages, including special, indirect, incidental, or
consequential damages, with respect to any claim arising
out of or in connection with the use of the software, even
if it has been or is hereafter advised of the possibility of
such damages.
*/
