/*
 * Bus schedule generator
 *
 * -c: compile tables
 * -l: list all routes
 *
 * Jim Rees, University of Michigan CITI, November 2000
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "xio.h"
#include "bus.h"

int cflag, Iflag, vflag;

main(ac, av)
int ac;
char *av[];
{
    int i, r = -1, s0 = -1, s1, s2, w = 0;
    char *cp;
    struct route *rt;

    while ((i = getopt(ac, av, "cIr:s:u:vw:")) != -1) {
	switch (i) {
	case 'c':
	    cflag = 1;
	    break;
	case 'I':
	    Iflag = 1;
	    break;
	case 'r':
	    r = atoi(optarg) - 1;
	    break;
	case 's':
	    cp = optarg;
	    s0 = *cp++ - '1';
	    s1 = cp[1] ? (*cp++ - '1') : -1;
	    s2 = (*cp > '9') ? (*cp - 'a' + 9) : (*cp - '1');
	    break;
	case 'u':
	    url = strdup(optarg);
	    break;
	case 'v':
	    vflag = 1;
	    break;
	case 'w':
	    w = atoi(optarg);
	    break;
	}
    }

    read_tables();

    if (Iflag) {
	print_info();
	exit(0);
    }

    if (cflag) {
	if (fetch_tables() < 0) {
	    printf("can't fetch %s\n", url);
	    exit(1);
	}
	store_tables();
	exit(0);
    }

    if (nroutes == 0) {
	printf("no routes\n");
	exit(2);
    }

    if (r < 0)
	for (i = 0; i < nroutes; i++)
	    printf("%2d %s\n", i + 1, routetab[i].name);
    else {
	rt = &routetab[r];
	if (s0 < 0) {
	    for (i = 0; i < rt->nstops; i++)
		printf("%2d %s\n", i + 1, stoptab[rt->stops[i]].name);
	    if (vflag)
		print_tables(rt);
	} else {
	    vrf_routes(r, 1);
	    makesched(rt, w, s0, s1, s2);
	}
    }

    exit(0);
}

/*
copyright 2000
the regents of the university of michigan
all rights reserved

permission is granted to use, copy, create derivative works 
and redistribute this software and such derivative works 
for any purpose, so long as the name of the university of 
michigan is not used in any advertising or publicity 
pertaining to the use or distribution of this software 
without specific, written prior authorization.  if the 
above copyright notice or any other identification of the 
university of michigan is included in any copy of any 
portion of this software, then the disclaimer below must 
also be included.

this software is provided as is, without representation 
from the university of michigan as to its fitness for any 
purpose, and without warranty by the university of 
michigan of any kind, either express or implied, including 
without limitation the implied warranties of 
merchantability and fitness for a particular purpose. the 
regents of the university of michigan shall not be liable 
for any damages, including special, indirect, incidental, or 
consequential damages, with respect to any claim arising 
out of or in connection with the use of the software, even 
if it has been or is hereafter advised of the possibility of 
such damages.
*/
