#define MAXSTOPS 16
#define MAXRUNS 16

#define RT_SIZE 1
#define RT_URL 2
#define RT_VERSION 3
#define RT_ROUTE 4
#define RT_STOP 5
#define RT_RUN 6
#define RT_INFO 7

extern int vflag;
extern char *url, *version, *info;

/* days field: 0 is weekday, 1 is Saturday, 2 is Sunday */
extern int nruns;
extern struct run {
    unsigned short days, freq, start, end, stops;
} *runtab;

extern int nstops;
extern struct stop {
    unsigned short time;
    char *name;
} *stoptab;

extern int nroutes;
extern struct route {
    unsigned short nstops;
    unsigned char stops[MAXSTOPS];
    unsigned short nruns;
    unsigned char runs[MAXRUNS];
    char *name;
} *routetab;

int makesched(struct route *rt, int wd, int s0, int s1, int s2);
int read_tables();
int fetch_tables();
int read_table_file(XFILE *f);
void store_tables();
void print_tables(struct route *rt);
void print_info();
