/*
 * Bus schedule generator
 *
 * Jim Rees, University of Michigan CITI, November 2000
 */

#ifdef __palmos__
#pragma pack(2)

#include <Common.h>
#include <System/SysAll.h>
#include <System/Unix/unix_stdio.h>
#include <System/Unix/unix_stdlib.h>
#include <UI/UIAll.h>
#include <string.h>

#include "field.h"

void qsort(char *base, int nel, int width, int (*compare)());
#else
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#endif

#include "xio.h"
#include "bus.h"
#include "tdb.h"

struct timetable {
    short t0, t1, t2;
};

int compar(const void *a0, const void *a1);
int add_mod60(int t0, int t1);

int vrf_routes(int r, int needroute)
{
    if (nroutes == 0)
	printf("no routes\n");
    else if (needroute && (r < 0 || r >= nroutes))
	printf("Please select a route in the range 1-%d\n", nroutes);
    else
	return 1;
    return 0;
}

static char *wnames[] = {
    "Weekday",
    "Saturday",
    "Sunday",
};

int makesched(struct route *rt, int wd, int s0, int s1, int s2)
{
    int i, t, rno = 0;
    struct stop *st0, *st1, *st2;
    struct run *r;
    struct timetable tab[100];

    if (s0 < 0 || s2 < 0 || s0 >= rt->nstops || s2 >= rt->nstops) {
	printf("Please select a stop in the range 1-%d\n", rt->nstops);
	return -1;
    }
    if (s1 > s2)
	s1 = s2;

    st0 = &stoptab[rt->stops[s0]];
    st1 = (s1 >= 0) ? &stoptab[rt->stops[s1]] : NULL;
    st2 = &stoptab[rt->stops[s2]];

    /* Make a list of all runs */

    for (i = 0; i < rt->nruns; i++) {
	r = &runtab[rt->runs[i]];
	for (t = r->start; t <= r->end; t = add_mod60(t, r->freq)) {
	    if (wd == r->days && ((1 << s0) & r->stops) && ((1 << s2) & r->stops)) {
		tab[rno].t0 = add_mod60(t, st0->time);
		if (st1 && ((1 << s1) & r->stops))
		    tab[rno].t1 = add_mod60(t, st1->time);
		else
		    tab[rno].t1 = -1;
		tab[rno].t2 = add_mod60(t, st2->time);
		rno++;
	    }
	}
    }

    /* Sort them */

    qsort((char *) &tab[0], rno, sizeof (struct timetable), compar);

    /* Print them out */

    if (s1 >= 0)
	printf("%s %s\n%s -> %s -> %s\n", wnames[wd], rt->name, st0->name, st1->name, st2->name);
    else
	printf("%s %s\n%s -> %s\n", wnames[wd], rt->name, st0->name, st2->name);

    for (i = 0; i < rno; i++)
	if (s1 >= 0) {
	    if (tab[i].t1 >= 0)
		printf("%4d %4d %4d\n", tab[i].t0, tab[i].t1, tab[i].t2);
	    else
		printf("%4d ---- %4d\n", tab[i].t0, tab[i].t2);
	} else
	    printf("%4d %4d\n", tab[i].t0, tab[i].t2);

    return 0;
}

int add_mod60(int t0, int t1)
{
    int m;

    m = (t0 / 100) * 60 + t0 % 100 + t1;
    return ((m / 60) * 100 + (m % 60));
}

int compar(const void *a0, const void *a1)
{
    return (((struct timetable *)a0)->t0 - ((struct timetable *)a1)->t0);
}

/*
copyright 2000
the regents of the university of michigan
all rights reserved

permission is granted to use, copy, create derivative works 
and redistribute this software and such derivative works 
for any purpose, so long as the name of the university of 
michigan is not used in any advertising or publicity 
pertaining to the use or distribution of this software 
without specific, written prior authorization.  if the 
above copyright notice or any other identification of the 
university of michigan is included in any copy of any 
portion of this software, then the disclaimer below must 
also be included.

this software is provided as is, without representation 
from the university of michigan as to its fitness for any 
purpose, and without warranty by the university of 
michigan of any kind, either express or implied, including 
without limitation the implied warranties of 
merchantability and fitness for a particular purpose. the 
regents of the university of michigan shall not be liable 
for any damages, including special, indirect, incidental, or 
consequential damages, with respect to any claim arising 
out of or in connection with the use of the software, even 
if it has been or is hereafter advised of the possibility of 
such damages.
*/
