/*
 * Open a connection to a port on a host.
 * Jim Rees, University of Michigan CITI
 */

#ifdef __palmos__
#pragma pack(2)

#if (__GNUC_MINOR__ > 7)
#include <PalmOS.h>
#else
#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>
#endif
#include <System/MemoryMgr.h>
#include <System/SysEvtMgr.h>
#include <System/DataMgr.h>

#include <System/Unix/unix_stdio.h>
#include <System/Unix/unix_stdlib.h>
#include <System/Unix/sys_types.h>
#include <System/Unix/sys_socket.h>
#include <string.h>

#include "field.h"
#else
#include <sys/types.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <netdb.h>
#endif

#include "conn.h"

#ifdef __palmos__
int netisopen;

/* I'm not sure what these are doing here. */
Err errno, h_errno;
Long AppNetTimeout;
NetHostInfoBufType AppHostInfo;
NetServInfoBufType AppServInfo;
Word AppNetRefnum;

Err
OpenNet()
{
    Err err;
    Word ifErrs;

    if (netisopen)
	return 0;

    err = SysLibFind("Net.lib", &AppNetRefnum);
    if (err)
	return err;

    err = NetLibOpen(AppNetRefnum, &ifErrs);
    if ((err && err != netErrAlreadyOpen) || ifErrs)
	return err;

    AppNetTimeout = SysTicksPerSecond() * 4;
    netisopen++;

    return 0;
}

Err
CloseNet()
{
    if (!netisopen)
	return 0;

    NetLibClose(AppNetRefnum, false);
    netisopen = 0;
    return 0;
}
#endif

int
openconn(char *hostname, int port, int flags)
{
    int fd;
    struct sockaddr_in saddr;
    struct hostent *hp;

    /* Resolve server name */

    bzero(&saddr, sizeof saddr);
    saddr.sin_family = AF_INET;
    saddr.sin_port = htons(port);
    if ((saddr.sin_addr.s_addr = inet_addr(hostname)) == -1) {
	if ((hp = gethostbyname(hostname)) == NULL) {
	    if (flags & 0x1)
		prerr("gethostbyname", errno);
	    return -1;
	}
	bcopy(hp->h_addr, &saddr.sin_addr, sizeof saddr.sin_addr);
    }

    /* Get a socket */

    if ((fd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
	if (flags & 0x1)
	    prerr("socket", errno);
	return -1;
    }

    /* Connect to the pop port */

    if (connect(fd, (struct sockaddr *) &saddr, sizeof saddr) < 0) {
	if (flags & 0x1)
	    prerr("connect", errno);
	close(fd);
	return -1;
    }

    return fd;
}

void
prerr(char *s, int err)
{
#ifdef __palmos__
    printf("%s: %s\n", s, geterr(err));
#else
    errno = err;
    perror(s);
#endif
}
