/*
 * Copyright (c) 2002 Marius Aamodt Eriksen <marius@umich.edu>
 */

/*
 * this file emulates openbsd's syscallnames[] array.  linux does not
 * have such a feature.  automatically generated from
 * arch/i386/kernel/entry.S
 */

char *linux_syscallnames[] = {
	"ni_syscall"
	"exit",
	"fork",
	"read",
	"write",
	"open",             /* 5 */
	"close",
	"waitpid",
	"creat",
	"link",
	"unlink",           /* 10 */
	"execve",
	"chdir",
	"time",
	"mknod",
	"chmod",            /* 15 */
	"lchown16",
	"ni_syscall",                       /* old break syscall holder */
	"stat",
	"lseek",
	"getpid",           /* 20 */
	"mount",
	"oldumount",
	"setuid16",
	"getuid16",
	"stime",            /* 25 */
	"ptrace",
	"alarm",
	"fstat",
	"pause",
	"utime",            /* 30 */
	"ni_syscall",       /* old stty syscall holder */
	"ni_syscall",       /* old gtty syscall holder */
	"access",
	"nice",
	"ni_syscall",       /* 35 */   /* old ftime syscall holder */
	"sync",
	"kill",
	"rename",
	"mkdir",
	"rmdir",            /* 40 */
	"dup",
	"pipe",
	"times",
	"ni_syscall",       /* old prof syscall holder */
	"brk",              /* 45 */
	"setgid16",
	"getgid16",
	"signal",
	"geteuid16",
	"getegid16",        /* 50 */
	"acct",
	"umount",           /* recycled never used phys() */
	"ni_syscall",       /* old lock syscall holder */
	"ioctl",
	"fcntl",            /* 55 */
	"ni_syscall",       /* old mpx syscall holder */
	"setpgid",
	"ni_syscall",       /* old ulimit syscall holder */
	"olduname",
	"umask",            /* 60 */
	"chroot",
	"ustat",
	"dup2",
	"getppid",
	"getpgrp",          /* 65 */
	"setsid",
	"sigaction",
	"sgetmask",
	"ssetmask",
	"setreuid16",       /* 70 */
	"setregid16",
	"sigsuspend",
	"sigpending",
	"sethostname",
	"setrlimit",        /* 75 */
	"old_getrlimit",
	"getrusage",
	"gettimeofday",
	"settimeofday",
	"getgroups16",      /* 80 */
	"setgroups16",
	"old_select",
	"symlink",
	"lstat",
	"readlink",         /* 85 */
	"uselib",
	"swapon",
	"reboot",
	"old_readdir",
	"old_mmap",             /* 90 */
	"munmap",
	"truncate",
	"ftruncate",
	"fchmod",
	"fchown16",         /* 95 */
	"getpriority",
	"setpriority",
	"ni_syscall",       /* old profil syscall holder */
	"statfs",
	"fstatfs",          /* 100 */
	"ioperm",
	"socketcall",
	"syslog",
	"setitimer",
	"getitimer",        /* 105 */
	"newstat",
	"newlstat",
	"newfstat",
	"uname",
	"iopl",             /* 110 */
	"vhangup",
	"ni_syscall",       /* old "idle" system call */
	"vm86old",
	"wait4",
	"swapoff",          /* 115 */
	"sysinfo",
	"ipc",
	"fsync",
	"sigreturn",
	"clone",            /* 120 */
	"setdomainname",
	"newuname",
	"modify_ldt",
	"adjtimex",
	"mprotect",         /* 125 */
	"sigprocmask",
	"create_module",
	"init_module",
	"delete_module",
	"get_kernel_syms",  /* 130 */
	"quotactl",
	"getpgid",
	"fchdir",
	"bdflush",
	"sysfs",            /* 135 */
	"personality",
	"ni_syscall",       /* for afs_syscall */
	"setfsuid16",
	"setfsgid16",
	"llseek",           /* 140 */
	"getdents",
	"select",
	"flock",
	"msync",
	"readv",            /* 145 */
	"writev",
	"getsid",
	"fdatasync",
	"sysctl",
	"mlock",            /* 150 */
	"munlock",
	"mlockall",
	"munlockall",
	"sched_setparam",
	"sched_getparam",   /* 155 */
	"sched_setscheduler",
	"sched_getscheduler",
	"sched_yield",
	"sched_get_priority_max",
	"sched_get_priority_min",  /* 160 */
	"sched_rr_get_interval",
	"nanosleep",
	"mremap",
	"setresuid16",
	"getresuid16",      /* 165 */
	"vm86",
	"query_module",
	"poll",
	"nfsservctl",
	"setresgid16",      /* 170 */
	"getresgid16",
	"prctl",
	"rt_sigreturn",
	"rt_sigaction",
	"rt_sigprocmask",   /* 175 */
	"rt_sigpending",
	"rt_sigtimedwait",
	"rt_sigqueueinfo",
	"rt_sigsuspend",
	"pread",            /* 180 */
	"pwrite",
	"chown16",
	"getcwd",
	"capget",
	"capset",           /* 185 */
	"sigaltstack",
	"sendfile",
	"ni_syscall",       /* streams1 */
	"ni_syscall",       /* streams2 */
	"vfork",            /* 190 */
	"getrlimit",
	"mmap2",
	"truncate64",
	"ftruncate64",
	"stat64",           /* 195 */
	"lstat64",
	"fstat64",
	"lchown",
	"getuid",
	"getgid",           /* 200 */
	"geteuid",
	"getegid",
	"setreuid",
	"setregid",
	"getgroups",        /* 205 */
	"setgroups",
	"fchown",
	"setresuid",
	"getresuid",
	"setresgid",        /* 210 */
	"getresgid",
	"chown",
	"setuid",
	"setgid",
	"setfsuid",         /* 215 */
	"setfsgid",
	"pivot_root",
	"mincore",
	"madvise",
	"getdents64",       /* 220 */
	"fcntl64",
	"ni_syscall",       /* reserved for TUX */
	"ni_syscall",       /* Reserved for Security */
	"gettid",
	"readahead",        /* 225 */
	"ni_syscall",       /* reserved for setxattr */
	"ni_syscall",       /* reserved for lsetxattr */
	"ni_syscall",       /* reserved for fsetxattr */
	"ni_syscall",       /* reserved for getxattr */
	"ni_syscall",       /* 230 reserved for lgetxattr */
	"ni_syscall",       /* reserved for fgetxattr */
	"ni_syscall",       /* reserved for listxattr */
	"ni_syscall",       /* reserved for llistxattr */
	"ni_syscall",       /* reserved for flistxattr */
	"ni_syscall",       /* 235 reserved for removexattr */
	"ni_syscall",       /* reserved for lremovexattr */
	"ni_syscall",       /* reserved for fremovexattr */
	"ni_syscall",
	"ni_syscall",
	"ni_syscall",	/* 240 */
	"ni_syscall",
	"ni_syscall",
	"ni_syscall",
	"ni_syscall",
	"ni_syscall",	/* 245 */
	"ni_syscall",
	"ni_syscall",
	"ni_syscall",
	"ni_syscall",
	"ni_syscall",	/* 250 */
	"ni_syscall",
	"ni_syscall",
	"ni_syscall",
	"ni_syscall",
	"ni_syscall",	/* 250 */
	"ni_syscall",	/* 256 */
	"ni_syscall",	/* 256 */
	"ni_syscall",	/* 256 */
};
