#ifndef lint
static char const 
yyrcsid[] = "$FreeBSD: src/usr.bin/yacc/skeleton.c,v 1.28.2.1 2001/07/19 05:46:39 peter Exp $";
#endif
#include <stdlib.h>
#define YYBYACC 1
#define YYMAJOR 1
#define YYMINOR 9
#define YYLEX yylex()
#define YYEMPTY -1
#define yyclearin (yychar=(YYEMPTY))
#define yyerrok (yyerrflag=0)
#define YYRECOVERING() (yyerrflag!=0)
#if defined(__cplusplus) || __STDC__
static int yygrowstack(void);
#else
static int yygrowstack();
#endif
#define YYPREFIX "yy"
#line 33 "parse.y"
#include <sys/types.h>

#include <sys/time.h>
#include <sys/tree.h>

#include <stdio.h>
#include <stdlib.h>
#include <err.h>
#include <stdarg.h>
#include <string.h>

#include "intercept.h"
#include "systrace.h"
#include "systrace-errno.h"

void yyrestart(FILE *);

int filter_fnmatch(struct intercept_translate *, struct logic *);
int filter_stringmatch(struct intercept_translate *, struct logic *);
int filter_negstringmatch(struct intercept_translate *, struct logic *);
int filter_substrmatch(struct intercept_translate *, struct logic *);
int filter_negsubstrmatch(struct intercept_translate *, struct logic *);
int filter_inpath(struct intercept_translate *, struct logic *);
int filter_true(struct intercept_translate *, struct logic *);

struct logic *parse_newsymbol(char *, int, char *);

int yylex(void);
int yyparse(void);

int errors = 0;
struct filter *myfilter;

#line 78 "parse.y"
typedef union {
	int number;
	char *string;
	short action;
	struct logic *logic;
} YYSTYPE;
#line 62 "parse.c"
#define YYERRCODE 256
#define AND 257
#define OR 258
#define NOT 259
#define LBRACE 260
#define RBRACE 261
#define LSQBRACE 262
#define RSQBRACE 263
#define THEN 264
#define MATCH 265
#define PERMIT 266
#define DENY 267
#define EQ 268
#define NEQ 269
#define TRUE 270
#define SUB 271
#define NSUB 272
#define INPATH 273
#define STRING 274
#define CMDSTRING 275
#define NUMBER 276
const short yylhs[] = {                                        -1,
    0,    6,    5,    5,    1,    1,    1,    1,    1,    2,
    2,    2,    2,    2,    2,    2,    4,    4,    3,    3,
};
const short yylen[] = {                                         2,
    1,    4,    0,    3,    1,    2,    3,    3,    3,    4,
    4,    4,    4,    4,    4,    1,    0,    3,    1,    1,
};
const short yydefred[] = {                                      0,
    0,    0,   16,    0,    0,    0,    5,    1,    0,    0,
    0,    0,    0,    0,    0,    7,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   19,   20,    0,   18,   10,
   11,   12,   13,   14,   15,    0,    2,    0,    4,
};
const short yydgoto[] = {                                       5,
    6,    7,   28,   12,   37,    8,
};
const short yysindex[] = {                                   -259,
 -259, -259,    0, -254,    0, -255,    0,    0, -245, -251,
 -262, -247, -259, -259, -229,    0, -244, -235, -234, -233,
 -231, -230, -228, -245, -245,    0,    0, -219,    0,    0,
    0,    0,    0,    0,    0, -246,    0, -217,    0,
};
const short yyrindex[] = {                                      0,
    0,    0,    0, -238,    0,    0,    0,    0, -241,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, -232, -225,    0,    0,   48,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,
};
const short yygindex[] = {                                      0,
    3,    0,    0,    0,    0,    0,
};
#define YYTABLESIZE 48
const short yytable[] = {                                       1,
    2,   13,   14,    9,   10,   13,   14,   11,   15,   16,
    3,   13,   14,   17,    4,   24,   25,   18,   29,    6,
   19,   20,    6,   21,   22,   23,   17,   38,    8,   17,
   17,    8,   17,   17,   17,    9,   26,   27,    9,   30,
   31,   32,   36,   33,   34,   39,   35,    3,
};
const short yycheck[] = {                                     259,
  260,  257,  258,    1,    2,  257,  258,  262,  264,  261,
  270,  257,  258,  276,  274,   13,   14,  265,  263,  261,
  268,  269,  264,  271,  272,  273,  265,  274,  261,  268,
  269,  264,  271,  272,  273,  261,  266,  267,  264,  275,
  275,  275,  262,  275,  275,  263,  275,    0,
};
#define YYFINAL 5
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 276
#if YYDEBUG
const char * const yyname[] = {
"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"AND","OR","NOT","LBRACE",
"RBRACE","LSQBRACE","RSQBRACE","THEN","MATCH","PERMIT","DENY","EQ","NEQ","TRUE",
"SUB","NSUB","INPATH","STRING","CMDSTRING","NUMBER",
};
const char * const yyrule[] = {
"$accept : filter",
"filter : fullexpression",
"fullexpression : expression THEN action errorcode",
"errorcode :",
"errorcode : LSQBRACE STRING RSQBRACE",
"expression : symbol",
"expression : NOT expression",
"expression : LBRACE expression RBRACE",
"expression : expression AND expression",
"expression : expression OR expression",
"symbol : STRING typeoff MATCH CMDSTRING",
"symbol : STRING typeoff EQ CMDSTRING",
"symbol : STRING typeoff NEQ CMDSTRING",
"symbol : STRING typeoff SUB CMDSTRING",
"symbol : STRING typeoff NSUB CMDSTRING",
"symbol : STRING typeoff INPATH CMDSTRING",
"symbol : TRUE",
"typeoff :",
"typeoff : LSQBRACE NUMBER RSQBRACE",
"action : PERMIT",
"action : DENY",
};
#endif
#if YYDEBUG
#include <stdio.h>
#endif
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 10000
#define YYMAXDEPTH 10000
#endif
#endif
#define YYINITSTACKSIZE 200
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short *yyss;
short *yysslim;
YYSTYPE *yyvs;
int yystacksize;
#line 276 "parse.y"

int
yyerror(char *fmt, ...)
{
	va_list ap;
	errors = 1;

	va_start(ap, fmt);
	vfprintf(stdout, fmt, ap);
	fprintf(stdout, "\n");
	va_end(ap);
	return (0);
}

struct logic *
parse_newsymbol(char *type, int typeoff, char *data)
{
	struct logic *node;
	node = calloc(1, sizeof(struct logic));

	if (node == NULL) {
		yyerror("calloc");
		return (NULL);
	}
	node->op = LOGIC_SINGLE;
	node->type = type;
	node->typeoff = typeoff;
	if (data) {
		node->filterdata = strdup(filter_expand(data));
		free(data);
		if (node->filterdata == NULL) {
			yyerror("strdup");
			return (NULL);
		}
		node->filterlen = strlen(node->filterdata) + 1;
	}

	return (node);
}

int
parse_filter(char *name, struct filter **pfilter)
{
	extern char *mystring;
	extern int myoff;
	extern struct filter *myfilter;

	errors = 0;

	myfilter = NULL;
	mystring = name;
	myoff = 0;

	yyparse();
	yyrestart(NULL);
	*pfilter = myfilter;
	return (errors ? -1 : 0);
}
#line 258 "parse.c"
/* allocate initial stack or double stack size, up to YYMAXDEPTH */
static int yygrowstack()
{
    int newsize, i;
    short *newss;
    YYSTYPE *newvs;

    if ((newsize = yystacksize) == 0)
        newsize = YYINITSTACKSIZE;
    else if (newsize >= YYMAXDEPTH)
        return -1;
    else if ((newsize *= 2) > YYMAXDEPTH)
        newsize = YYMAXDEPTH;
    i = yyssp - yyss;
    newss = yyss ? (short *)realloc(yyss, newsize * sizeof *newss) :
      (short *)malloc(newsize * sizeof *newss);
    if (newss == NULL)
        return -1;
    yyss = newss;
    yyssp = newss + i;
    newvs = yyvs ? (YYSTYPE *)realloc(yyvs, newsize * sizeof *newvs) :
      (YYSTYPE *)malloc(newsize * sizeof *newvs);
    if (newvs == NULL)
        return -1;
    yyvs = newvs;
    yyvsp = newvs + i;
    yystacksize = newsize;
    yysslim = yyss + newsize - 1;
    return 0;
}

#define YYABORT goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab

#ifndef YYPARSE_PARAM
#if defined(__cplusplus) || __STDC__
#define YYPARSE_PARAM_ARG void
#define YYPARSE_PARAM_DECL
#else	/* ! ANSI-C/C++ */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif	/* ANSI-C/C++ */
#else	/* YYPARSE_PARAM */
#ifndef YYPARSE_PARAM_TYPE
#define YYPARSE_PARAM_TYPE void *
#endif
#if defined(__cplusplus) || __STDC__
#define YYPARSE_PARAM_ARG YYPARSE_PARAM_TYPE YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else	/* ! ANSI-C/C++ */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL YYPARSE_PARAM_TYPE YYPARSE_PARAM;
#endif	/* ANSI-C/C++ */
#endif	/* ! YYPARSE_PARAM */

int
yyparse (YYPARSE_PARAM_ARG)
    YYPARSE_PARAM_DECL
{
    register int yym, yyn, yystate;
#if YYDEBUG
    register const char *yys;

    if ((yys = getenv("YYDEBUG")))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    if (yyss == NULL && yygrowstack()) goto yyoverflow;
    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if ((yyn = yydefred[yystate])) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, reading %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: state %d, shifting to state %d\n",
                    YYPREFIX, yystate, yytable[yyn]);
#endif
        if (yyssp >= yysslim && yygrowstack())
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#if defined(lint) || defined(__GNUC__)
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#if defined(lint) || defined(__GNUC__)
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: state %d, error recovery shifting\
 to state %d\n", YYPREFIX, *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yysslim && yygrowstack())
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: error recovery discarding state %d\n",
                            YYPREFIX, *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, error recovery discards token %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: state %d, reducing by rule %d (%s)\n",
                YYPREFIX, yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    yyval = yyvsp[1-yym];
    switch (yyn)
    {
case 2:
#line 90 "parse.y"
{
		int flags = 0, errorcode = SYSTRACE_EPERM;

		switch (yyvsp[-1].action) {
		case ICPOLICY_NEVER:
			if (yyvsp[0].string == NULL)
				break;
			errorcode = systrace_error_translate(yyvsp[0].string);
			if (errorcode == -1)
				yyerror("Unknown error code: %s", yyvsp[0].string);
			break;
		case ICPOLICY_PERMIT:
			if (yyvsp[0].string == NULL)
				break;
			if (!strcasecmp(yyvsp[0].string, "inherit"))
				flags = PROCESS_INHERIT_POLICY;
			break;
		}

		if (yyvsp[0].string != NULL)
			free(yyvsp[0].string);

		myfilter = calloc(1, sizeof(struct filter));
		if (myfilter == NULL) {
			yyerror("calloc");
			break;
		}
		myfilter->logicroot = yyvsp[-3].logic;
		myfilter->match_action = yyvsp[-1].action;
		myfilter->match_error = errorcode;
		myfilter->match_flags = flags;
	}
break;
case 3:
#line 125 "parse.y"
{
	yyval.string = NULL;
}
break;
case 4:
#line 129 "parse.y"
{
	yyval.string = yyvsp[-1].string;
}
break;
case 5:
#line 135 "parse.y"
{
	yyval.logic = yyvsp[0].logic;
}
break;
case 6:
#line 139 "parse.y"
{
	struct logic *node;
	node = calloc(1, sizeof(struct logic));
	if (node == NULL) {
		yyerror("calloc");
		break;
	}
	node->op = LOGIC_NOT;
	node->left = yyvsp[0].logic;
	yyval.logic = node;
}
break;
case 7:
#line 151 "parse.y"
{
	yyval.logic = yyvsp[-1].logic;
}
break;
case 8:
#line 155 "parse.y"
{
	struct logic *node;
	node = calloc(1, sizeof(struct logic));
	if (node == NULL) {
		yyerror("calloc");
		break;
	}
	node->op = LOGIC_AND;
	node->left = yyvsp[-2].logic;
	node->right = yyvsp[0].logic;
	yyval.logic = node;
}
break;
case 9:
#line 168 "parse.y"
{
	struct logic *node;
	node = calloc(1, sizeof(struct logic));
	if (node == NULL) {
		yyerror("calloc");
		break;
	}
	node->op = LOGIC_OR;
	node->left = yyvsp[-2].logic;
	node->right = yyvsp[0].logic;
	yyval.logic = node;
}
break;
case 10:
#line 183 "parse.y"
{
	struct logic *node;

	if ((node = parse_newsymbol(yyvsp[-3].string, yyvsp[-2].number, yyvsp[0].string)) == NULL)
		break;

	node->filter_match = filter_fnmatch;
	yyval.logic = node;
}
break;
case 11:
#line 193 "parse.y"
{
	struct logic *node;

	if ((node = parse_newsymbol(yyvsp[-3].string, yyvsp[-2].number, yyvsp[0].string)) == NULL)
		break;

	node->filter_match = filter_stringmatch;
	yyval.logic = node;
}
break;
case 12:
#line 203 "parse.y"
{
	struct logic *node;

	if ((node = parse_newsymbol(yyvsp[-3].string, yyvsp[-2].number, yyvsp[0].string)) == NULL)
		break;

	node->filter_match = filter_negstringmatch;
	yyval.logic = node;
}
break;
case 13:
#line 213 "parse.y"
{
	struct logic *node;

	if ((node = parse_newsymbol(yyvsp[-3].string, yyvsp[-2].number, yyvsp[0].string)) == NULL)
		break;

	node->filter_match = filter_substrmatch;
	yyval.logic = node;
}
break;
case 14:
#line 223 "parse.y"
{
	struct logic *node;

	if ((node = parse_newsymbol(yyvsp[-3].string, yyvsp[-2].number, yyvsp[0].string)) == NULL)
		break;

	node->filter_match = filter_negsubstrmatch;
	yyval.logic = node;
}
break;
case 15:
#line 233 "parse.y"
{
	struct logic *node;

	if ((node = parse_newsymbol(yyvsp[-3].string, yyvsp[-2].number, yyvsp[0].string)) == NULL)
		break;

	node->filter_match = filter_inpath;
	yyval.logic = node;
}
break;
case 16:
#line 243 "parse.y"
{
	struct logic *node;

	if ((node = parse_newsymbol(NULL, -1, NULL)) == NULL)
		break;

	node->filter_match = filter_true;
	yyval.logic = node;
}
break;
case 17:
#line 255 "parse.y"
{
	yyval.number = -1;
}
break;
case 18:
#line 259 "parse.y"
{
	if (yyvsp[-1].number < 0 || yyvsp[-1].number >= INTERCEPT_MAXSYSCALLARGS) {
		yyerror("Bad offset: %d", yyvsp[-1].number);
		break;
	}
	yyval.number = yyvsp[-1].number;
}
break;
case 19:
#line 268 "parse.y"
{
	yyval.action = ICPOLICY_PERMIT;
}
break;
case 20:
#line 272 "parse.y"
{
	yyval.action = ICPOLICY_NEVER;
}
break;
#line 668 "parse.c"
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: after reduction, shifting from state 0 to\
 state %d\n", YYPREFIX, YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("%sdebug: state %d, reading %d (%s)\n",
                        YYPREFIX, YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: after reduction, shifting from state %d \
to state %d\n", YYPREFIX, *yyssp, yystate);
#endif
    if (yyssp >= yysslim && yygrowstack())
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    return (1);
yyaccept:
    return (0);
}
