/*

Copyright (C) 2003 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __honeycomb_h
#define __honeycomb_h

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>

#ifdef HAVE_DUMBNET
#include <dumbnet.h>
#else
#include <dnet.h>
#endif


/* The values #defined below are all values that influence the
 * performance and behaviour of the plugin. All this stuff should
 * eventually be user-configurable in a config file!
 */

/* What Snort alert category we use for our signatures: */
#define HC_SNORT_ALERT_CLASS            "honeyd"


/* How many UDP packets we keep in mind and search
 * for matching data. 
 */
#define HC_IP_BACKLOG                   100


/* How many UDP packets we keep in mind and search
 * for matching data
 */
#define HC_UDP_BACKLOG                  100

/* The minimum pattern length we require before we consider
 * a string match in UDP payload meaningful:
 */
#define HC_UDP_PATTERN_MINLEN           5


/* How many TCP connections we maintain state for at any one time */
#define HC_TCP_MAXCONNS                 100

/* The number of slots in the TCP hashtable */
#define HC_TCP_CONNSHASH_SIZE           199

/* The maximum number of bytes flowing in a single direction during
 * the TCP dialog that we store. More data going in one direction
 * without any real data going the other way is not stored, as
 * we're currently not looking for data there.
 *
 * This is also the maximum string size the longest common substring
 * algorithm in libstree needs to deal with, so we don't make this
 * too high to not reduce performance too much.
 */
#define HC_TCP_STREAM_PART_SIZE         5000

/* In an interactive TCP flow, we can stop hunting for patterns at
 * some point. The following defines the number of messages exchanged
 * (ie real payload going in one direction without any real payload
 * going the other way) before we stop accumulating state.
 */
#define HC_TCP_STREAM_NUM_PARTS         10

/* The minimum pattern length we require before we consider
 * a string match in TCP payload meaningful:
 */
#define HC_TCP_PATTERN_MINLEN           5


/* How many generated signatures we keep around before we
 * start to forget some.
 */
#define HC_SIGHIST_MAX_SIZE             200

/* The name of the output log file to which we log generated signatures. */
#define HC_SIG_OUTPUT_FILE              "/tmp/honeycomb.log"

#endif
