/*

Copyright (C) 2003 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <libstree.h>

#include <honeyd/hooks.h>
#include "honeycomb.h"
#include "hc_ip.h"
#include "hc_udp.h"
#include "hc_tcp.h"
#include "hc_tcp_conns.h"
#include "hc_signature.h"
#include "hc_signature_hist.h"
#include "hc_snort_printer.h"
#include "hc_file_logger.h"


const char *
name(void)
{
	return "Honeycomb";
}


const char *
description(void)
{
	return "The Honeycomb plugin analyzes traffic going through the "
		"honeypot and tries to generate IDS signatures accurately "
		"describing anomalies and repeated patterns in that traffic";
}


const char *
author(void)
{
	return "Christian Kreibich, <christian@whoop.org>";
}

const char *
version(void)
{
	return "0.1.0";
}


void
init (void)
{
	/* Honeycomb initialization: any values used in here
	 * should come from a config file, but for now are
	 * defined in honeycomb.h ...
	 */

	/* Initialize libstree -- we want to use its algorithms on
	 * binary data, so set the printer function to hex output.
	 * The other default string handling implementations are
	 * correct by default.
	 */
	lst_stringclass_set_defaults(NULL, NULL, lst_string_print_hex);
	
	/* Initialize the protocol handlers -- they hook
	 * themselves into Honeyd's packet rx/tx code
	 */
	hc_ip_init();
	hc_udp_init();
	hc_tcp_init();

	/* Initialize TCP stream reassembler. */
	hc_tcp_conns_init(HC_TCP_MAXCONNS);
	
	/* Print Snort rules for now -- this should really
	 * rather be user-configurable.
	 */
	hc_sig_set_printer(hc_sig_print_snort);

	/* Initialize signature history. It prevents us from
	 * reporting duplicate signatures.
	 */
	hc_sighist_init();
	hc_sighist_set_max_size(HC_SIGHIST_MAX_SIZE);

	/* Initialize the signature output mechanism. This
	 * should be much more configurable, but for now
	 * we just print to a logfile.
	 */
	hc_file_logger_init(HC_SIG_OUTPUT_FILE);
}
