/*

Copyright (C) 2003 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <strings.h>
#include <syslog.h>

#include "hc_debug.h"
#include "hc_signature_hist.h"
#include "hc_file_logger.h"

FILE   *logfile;

static void      
hc_file_logger_log_sig(HC_Signature *sig, void *user_data)
{
	char sigstring[MAXPATHLEN];
	
	if (!logfile)
		return;

	hc_sig_print(sig, sigstring, MAXPATHLEN);
	fprintf(logfile, "%s\n", sigstring);
	fflush(logfile);
	syslog(LOG_INFO, "created new signature");
}


void      
hc_file_logger_init(const char *filename)
{
	if (!filename || !*filename)
		return;
	
	if (logfile) {
		fclose(logfile);
	}
	
	if (! (logfile = fopen(filename, "a+"))) {
		D(("Logfile couldn't be created\n"));
		return;
	}
	
	hc_sighist_set_insert_callback(hc_file_logger_log_sig, NULL);
}
