#ifndef lint
static char const 
yyrcsid[] = "$FreeBSD: src/usr.bin/yacc/skeleton.c,v 1.28 2000/01/17 02:04:06 bde Exp $";
#endif
#include <stdlib.h>
#define YYBYACC 1
#define YYMAJOR 1
#define YYMINOR 9
#define YYLEX yylex()
#define YYEMPTY -1
#define yyclearin (yychar=(YYEMPTY))
#define yyerrok (yyerrflag=0)
#define YYRECOVERING() (yyerrflag!=0)
static int yygrowstack();
#define yyparse hd_parse
#define yylex hd_lex
#define yyerror hd_error
#define yychar hd_char
#define yyval hd_val
#define yylval hd_lval
#define yydebug hd_debug
#define yynerrs hd_nerrs
#define yyerrflag hd_errflag
#define yyss hd_ss
#define yyssp hd_ssp
#define yyvs hd_vs
#define yyvsp hd_vsp
#define yylhs hd_lhs
#define yylen hd_len
#define yydefred hd_defred
#define yydgoto hd_dgoto
#define yysindex hd_sindex
#define yyrindex hd_rindex
#define yygindex hd_gindex
#define yytable hd_table
#define yycheck hd_check
#define yyname hd_name
#define yyrule hd_rule
#define yysslim hd_sslim
#define yystacksize hd_stacksize
#define YYPREFIX "hd_"
#line 31 "parse.y"
#include <sys/types.h>

#include "config.h"

#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#endif
#include <sys/tree.h>
#include <sys/queue.h>

#include <stdio.h>
#include <stdlib.h>
#include <err.h>
#include <stdarg.h>
#include <string.h>

#include <dnet.h>

#include <event.h>

#include "honeyd.h"
#include "personality.h"
#include "router.h"

int yylex(void);
int yyparse(void);
int yyerror(char *, ...);

struct template;
int template_create(char *);
int template_add(struct template *, int, int, struct action *);
int template_subsystem(struct template *, char *);
int template_clone(char *, struct template *, int);
struct template *template_find(char *);

struct action *honeyd_protocol(struct template *, int);

void port_action_clone(struct action *, struct action *);

int lineno;
char *filename;
int errors = 0;
int curtype = -1;	/* Lex sets it to SOCK_STREAM or _DGRAM */

#line 96 "parse.y"
typedef union {
	char *string;
	int number;
	struct addr addr;
	struct action action;
	struct template *tmpl;
	struct personality *pers;
	struct addrinfo *ai;
	enum fragpolicy fragp;
	float floatp;
} YYSTYPE;
#line 100 "parse.c"
#define YYERRCODE 256
#define CREATE 257
#define ADD 258
#define PORT 259
#define BIND 260
#define CLONE 261
#define DOT 262
#define BLOCK 263
#define OPEN 264
#define RESET 265
#define DEFAULT 266
#define SET 267
#define ACTION 268
#define PERSONALITY 269
#define RANDOM 270
#define ANNOTATE 271
#define NO 272
#define FINSCAN 273
#define FRAGMENT 274
#define DROP 275
#define OLD 276
#define NEW 277
#define COLON 278
#define PROXY 279
#define UPTIME 280
#define DROPRATE 281
#define IN 282
#define UID 283
#define GID 284
#define ROUTE 285
#define ENTRY 286
#define LINK 287
#define NET 288
#define SLASH 289
#define LATENCY 290
#define MS 291
#define LOSS 292
#define SUBSYSTEM 293
#define STRING 294
#define CMDSTRING 295
#define NUMBER 296
#define PROTO 297
const short hd_lhs[] = {                                        -1,
    0,    0,    0,    0,    0,    0,    0,    0,   12,   12,
   13,   14,   15,   15,   16,   16,   16,   16,   16,   16,
   17,   17,   18,   18,   18,    7,    7,    8,    8,    8,
    1,    2,    3,    4,    4,    4,    4,    4,    4,    4,
    4,    5,    5,    5,    6,    6,    9,    9,   10,   10,
   11,   11,
};
const short hd_len[] = {                                         2,
    0,    2,    2,    2,    2,    2,    2,    2,    2,    2,
    6,    4,    3,    3,    6,    4,    4,    5,    4,    6,
    3,    3,    3,    8,    4,    1,    2,    2,    2,    2,
    7,    3,    3,    1,    1,    2,    4,    4,    1,    1,
    1,    1,    1,    1,    1,    1,    3,    1,    0,    3,
    0,    2,
};
const short hd_defred[] = {                                      1,
    0,    0,    0,    0,    0,    0,    0,    0,    2,    3,
    4,    5,    6,    7,    8,   10,    9,   43,   42,    0,
   44,    0,    0,    0,    0,   46,   45,    0,    0,    0,
    0,    0,    0,   13,   14,    0,    0,    0,    0,    0,
    0,   26,    0,   21,   22,   23,    0,    0,    0,   12,
    0,    0,   16,   17,    0,    0,   27,   28,   29,   30,
    0,    0,   25,    0,    0,    0,    0,   18,    0,    0,
    0,    0,   39,   41,   40,    0,   34,   35,   11,   15,
    0,   20,    0,   32,    0,    0,    0,   36,   47,    0,
    0,   31,    0,    0,    0,    0,   24,   38,   37,   33,
   50,   52,
};
const short hd_dgoto[] = {                                       1,
   21,   63,   88,   79,   22,   28,   44,   45,   68,   91,
   97,    9,   10,   11,   12,   13,   14,   15,
};
const short hd_sindex[] = {                                      0,
 -215, -263, -264, -283, -272, -264, -259, -279,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, -234,
    0, -246, -264, -264, -254,    0,    0, -224, -283, -253,
 -261, -262, -218,    0,    0, -239, -259, -237, -221, -236,
 -211,    0, -222,    0,    0,    0, -225, -283, -198,    0,
 -231, -201,    0,    0, -228, -213,    0,    0,    0,    0,
 -283, -220,    0, -223, -255, -255, -188,    0, -219, -283,
 -217, -187,    0,    0,    0, -280,    0,    0,    0,    0,
 -216,    0, -214,    0, -212, -200, -197,    0,    0, -210,
 -209,    0, -275, -208, -206, -228,    0,    0,    0,    0,
    0,    0,
};
const short hd_rindex[] = {                                      0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    6,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   18,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    1,    0,    0,    0,    0,    0,    0,    0,
   23,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,
};
const short hd_gindex[] = {                                      0,
   -4,   21,    0,   24,   14,   50,    0,    0,   -7,    0,
    0,    0,    0,    0,    0,    0,    0,    0,
};
#define YYTABLESIZE 308
const short hd_table[] = {                                      23,
   49,   18,   16,   30,   47,   19,   29,   73,   74,   75,
   26,   36,   20,   86,   37,   20,   20,   48,   98,   25,
   99,   24,   51,   76,   46,   38,   39,   31,   40,   19,
   17,   20,   50,   48,   49,   27,   34,   35,   77,   78,
   51,    2,    3,   62,    4,    5,   32,   41,   42,   43,
   33,    6,   58,   59,   60,    7,   62,   52,   54,   56,
   55,   57,   61,   64,   65,   83,   66,   67,   71,    8,
   69,   87,   72,   81,   85,   90,   82,   93,   84,   89,
   94,   70,   96,   92,  101,   95,   53,  100,  102,   80,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   49,   49,    0,
   49,   49,   19,   19,    0,   19,   19,   49,    0,    0,
    0,   49,   19,    0,   48,   48,   19,   48,   48,   51,
   51,    0,   51,   51,   48,   49,    0,    0,   48,   51,
   19,    0,   49,   51,    0,    0,    0,    0,    0,    0,
    0,    0,   48,    0,    0,    0,    0,   51,
};
const short hd_check[] = {                                       4,
    0,  266,  266,    8,  258,    0,  286,  263,  264,  265,
  270,  266,  296,  294,  269,  296,  296,    0,  294,    6,
  296,  294,    0,  279,   29,  280,  281,  262,  283,  294,
  294,  296,  295,  287,  296,  295,   23,   24,  294,  295,
  259,  257,  258,   48,  260,  261,  293,  272,  273,  274,
  297,  267,  275,  276,  277,  271,   61,  297,  296,  296,
  282,  273,  288,  262,  296,   70,  268,  296,  289,  285,
  284,   76,  296,  262,  262,  290,  296,  278,  296,  296,
  278,   61,  292,  296,  291,  296,   37,  296,   96,   66,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258,   -1,
  260,  261,  257,  258,   -1,  260,  261,  267,   -1,   -1,
   -1,  271,  267,   -1,  257,  258,  271,  260,  261,  257,
  258,   -1,  260,  261,  267,  285,   -1,   -1,  271,  267,
  285,   -1,  292,  271,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  285,   -1,   -1,   -1,   -1,  285,
};
#define YYFINAL 1
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 297
#if YYDEBUG
const char * const hd_name[] = {
"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"CREATE","ADD","PORT","BIND",
"CLONE","DOT","BLOCK","OPEN","RESET","DEFAULT","SET","ACTION","PERSONALITY",
"RANDOM","ANNOTATE","NO","FINSCAN","FRAGMENT","DROP","OLD","NEW","COLON",
"PROXY","UPTIME","DROPRATE","IN","UID","GID","ROUTE","ENTRY","LINK","NET",
"SLASH","LATENCY","MS","LOSS","SUBSYSTEM","STRING","CMDSTRING","NUMBER","PROTO",
};
const char * const hd_rule[] = {
"$accept : config",
"config :",
"config : config creation",
"config : config addition",
"config : config subsystem",
"config : config binding",
"config : config set",
"config : config annotate",
"config : config route",
"creation : CREATE STRING",
"creation : CREATE DEFAULT",
"addition : ADD template PROTO PORT NUMBER action",
"subsystem : ADD template SUBSYSTEM CMDSTRING",
"binding : BIND ipaddr template",
"binding : CLONE STRING template",
"set : SET template DEFAULT PROTO ACTION action",
"set : SET template PERSONALITY personality",
"set : SET template UPTIME NUMBER",
"set : SET template DROPRATE IN rate",
"set : SET template UID NUMBER",
"set : SET template UID NUMBER GID NUMBER",
"annotate : ANNOTATE personality finscan",
"annotate : ANNOTATE personality fragment",
"route : ROUTE ENTRY ipaddr",
"route : ROUTE ipaddr ADD NET ipnet ipaddr latency packetloss",
"route : ROUTE ipaddr LINK ipnet",
"finscan : FINSCAN",
"finscan : NO FINSCAN",
"fragment : FRAGMENT DROP",
"fragment : FRAGMENT OLD",
"fragment : FRAGMENT NEW",
"ipaddr : NUMBER DOT NUMBER DOT NUMBER DOT NUMBER",
"ipnet : ipaddr SLASH NUMBER",
"ipaddrplusport : ipaddr COLON NUMBER",
"action : STRING",
"action : CMDSTRING",
"action : PROXY ipaddrplusport",
"action : PROXY STRING COLON NUMBER",
"action : PROXY STRING COLON STRING",
"action : BLOCK",
"action : RESET",
"action : OPEN",
"template : STRING",
"template : DEFAULT",
"template : ipaddr",
"personality : CMDSTRING",
"personality : RANDOM",
"rate : NUMBER DOT NUMBER",
"rate : NUMBER",
"latency :",
"latency : LATENCY NUMBER MS",
"packetloss :",
"packetloss : LOSS rate",
};
#endif
#if YYDEBUG
#include <stdio.h>
#endif
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 10000
#define YYMAXDEPTH 10000
#endif
#endif
#define YYINITSTACKSIZE 200
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short *yyss;
short *yysslim;
YYSTYPE *yyvs;
int yystacksize;
#line 441 "parse.y"

int
yyerror(char *fmt, ...)
{
	va_list ap;
	errors = 1;

	va_start(ap, fmt);
	fprintf(stderr, "%s:%d: ", filename, lineno);
	vfprintf(stderr, fmt, ap);
	fprintf(stderr, "\n");
	va_end(ap);
	return (0);
}

int
parse_configuration(FILE *input, char *name)
{
	extern FILE *hd_in;

	lineno = 1;
	filename = name;
	hd_in = input;
	yyparse();
	return (errors ? -1 : 0);
}
#line 402 "parse.c"
/* allocate initial stack or double stack size, up to YYMAXDEPTH */
static int yygrowstack()
{
    int newsize, i;
    short *newss;
    YYSTYPE *newvs;

    if ((newsize = yystacksize) == 0)
        newsize = YYINITSTACKSIZE;
    else if (newsize >= YYMAXDEPTH)
        return -1;
    else if ((newsize *= 2) > YYMAXDEPTH)
        newsize = YYMAXDEPTH;
    i = yyssp - yyss;
    newss = yyss ? (short *)realloc(yyss, newsize * sizeof *newss) :
      (short *)malloc(newsize * sizeof *newss);
    if (newss == NULL)
        return -1;
    yyss = newss;
    yyssp = newss + i;
    newvs = yyvs ? (YYSTYPE *)realloc(yyvs, newsize * sizeof *newvs) :
      (YYSTYPE *)malloc(newsize * sizeof *newvs);
    if (newvs == NULL)
        return -1;
    yyvs = newvs;
    yyvsp = newvs + i;
    yystacksize = newsize;
    yysslim = yyss + newsize - 1;
    return 0;
}

#define YYABORT goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab

#ifndef YYPARSE_PARAM
#if defined(__cplusplus) || __STDC__
#define YYPARSE_PARAM_ARG void
#define YYPARSE_PARAM_DECL
#else	/* ! ANSI-C/C++ */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif	/* ANSI-C/C++ */
#else	/* YYPARSE_PARAM */
#ifndef YYPARSE_PARAM_TYPE
#define YYPARSE_PARAM_TYPE void *
#endif
#if defined(__cplusplus) || __STDC__
#define YYPARSE_PARAM_ARG YYPARSE_PARAM_TYPE YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else	/* ! ANSI-C/C++ */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL YYPARSE_PARAM_TYPE YYPARSE_PARAM;
#endif	/* ANSI-C/C++ */
#endif	/* ! YYPARSE_PARAM */

int
yyparse (YYPARSE_PARAM_ARG)
    YYPARSE_PARAM_DECL
{
    register int yym, yyn, yystate;
#if YYDEBUG
    register const char *yys;

    if ((yys = getenv("YYDEBUG")))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    if (yyss == NULL && yygrowstack()) goto yyoverflow;
    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if ((yyn = yydefred[yystate])) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, reading %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: state %d, shifting to state %d\n",
                    YYPREFIX, yystate, yytable[yyn]);
#endif
        if (yyssp >= yysslim && yygrowstack())
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#if defined(lint) || defined(__GNUC__)
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#if defined(lint) || defined(__GNUC__)
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: state %d, error recovery shifting\
 to state %d\n", YYPREFIX, *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yysslim && yygrowstack())
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: error recovery discarding state %d\n",
                            YYPREFIX, *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, error recovery discards token %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: state %d, reducing by rule %d (%s)\n",
                YYPREFIX, yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    yyval = yyvsp[1-yym];
    switch (yyn)
    {
case 9:
#line 120 "parse.y"
{
		if (template_create(yyvsp[0].string) == -1)
			yyerror("Template \"%s\" exists already", yyvsp[0].string);
		free(yyvsp[0].string);
	}
break;
case 10:
#line 126 "parse.y"
{
		if (template_create("default") == -1)
			yyerror("Template \"default\" exists already");
	}
break;
case 11:
#line 133 "parse.y"
{
		if (yyvsp[-4].tmpl != NULL && template_add(yyvsp[-4].tmpl, yyvsp[-3].number, yyvsp[-1].number, &yyvsp[0].action) == -1)
			yyerror("Can not add port %d to template \"%s\"",
			    yyvsp[-1].number, yyvsp[-4].tmpl != NULL ? yyvsp[-4].tmpl->name : "<unknown>");
		if (yyvsp[0].action.action)
			free(yyvsp[0].action.action);
	}
break;
case 12:
#line 142 "parse.y"
{
		yyvsp[0].string[strlen(yyvsp[0].string) - 1] = '\0';
		if (yyvsp[-2].tmpl != NULL && template_subsystem(yyvsp[-2].tmpl, yyvsp[0].string+1) == -1)
			yyerror("Can not add subsystem \"%s\" to template \"%s\"",
			    yyvsp[0].string+1, yyvsp[-2].tmpl != NULL ? yyvsp[-2].tmpl->name : "<unknown>");
		free(yyvsp[0].string);
	}
break;
case 13:
#line 151 "parse.y"
{
		/* Bind to an IP address and start subsystems */
		if (yyvsp[0].tmpl == NULL || template_clone(addr_ntoa(&yyvsp[-1].addr), yyvsp[0].tmpl, 1) == -1)
			yyerror("Binding to %s failed", addr_ntoa(&yyvsp[-1].addr));
	}
break;
case 14:
#line 157 "parse.y"
{
		/* Just clone.  This is not the final destination yet */
		if (yyvsp[0].tmpl == NULL || template_clone(yyvsp[-1].string, yyvsp[0].tmpl, 0) == -1)
			yyerror("Cloning to %s failed", yyvsp[-1].string);
		free(yyvsp[-1].string);
	}
break;
case 15:
#line 165 "parse.y"
{
		struct action *action;

		if (yyvsp[-4].tmpl == NULL) {
			yyerror("No template");
			break;
		}
		
		if ((action = honeyd_protocol(yyvsp[-4].tmpl, yyvsp[-2].number)) == NULL) {
			yyerror("Bad protocol");
			break;
		}

		port_action_clone(action, &yyvsp[0].action);
		if (yyvsp[0].action.action != NULL)
			free(yyvsp[0].action.action);
	}
break;
case 16:
#line 183 "parse.y"
{
		if (yyvsp[-2].tmpl == NULL || yyvsp[0].pers == NULL)
			break;
		yyvsp[-2].tmpl->person = yyvsp[0].pers;
	}
break;
case 17:
#line 189 "parse.y"
{
		if (yyvsp[-2].tmpl == NULL || yyvsp[0].number == 0)
			break;
		yyvsp[-2].tmpl->timestamp = yyvsp[0].number * 2;
	}
break;
case 18:
#line 195 "parse.y"
{
		if (yyvsp[-3].tmpl == NULL)
			break;
		if (yyvsp[0].floatp > 100) {
			yyerror("Droprate too high: %f", yyvsp[0].floatp);
			break;
		}

		yyvsp[-3].tmpl->drop_inrate = yyvsp[0].floatp * 100;
	}
break;
case 19:
#line 206 "parse.y"
{
		if (yyvsp[-2].tmpl == NULL)
			break;
		if (!yyvsp[0].number) {
			yyerror("Bad uid %d", yyvsp[0].number);
			break;
		}
		yyvsp[-2].tmpl->uid = yyvsp[0].number;
	}
break;
case 20:
#line 216 "parse.y"
{
		if (yyvsp[-4].tmpl == NULL)
			break;
		if (!yyvsp[-2].number || !yyvsp[0].number) {
			yyerror("Bad uid %d, gid %d", yyvsp[-2].number, yyvsp[0].number);
			break;
		}
		yyvsp[-4].tmpl->uid = yyvsp[-2].number;
		yyvsp[-4].tmpl->gid = yyvsp[0].number;
	}
break;
case 21:
#line 228 "parse.y"
{
		if (yyvsp[-1].pers == NULL)
			break;
		yyvsp[-1].pers->disallow_finscan = !yyvsp[0].number;
	}
break;
case 22:
#line 234 "parse.y"
{
		if (yyvsp[-1].pers == NULL)
			break;
		yyvsp[-1].pers->fragp = yyvsp[0].fragp;
	}
break;
case 23:
#line 241 "parse.y"
{
		if (router_start(&yyvsp[0].addr) == -1)
			yyerror("Defining entry point failed");
	}
break;
case 24:
#line 246 "parse.y"
{
		struct router *r;

		if ((r = router_find(&yyvsp[-6].addr)) == NULL) {
			yyerror("Unknown router %s", addr_ntoa(&yyvsp[-6].addr));
			break;
		}
		if (router_find(&yyvsp[-2].addr) == NULL)
			router_new(&yyvsp[-2].addr);
		if (router_add_net(r, &yyvsp[-3].addr, &yyvsp[-2].addr, yyvsp[-1].number, yyvsp[0].number) == -1)
			yyerror("Could not add route to %s", addr_ntoa(&yyvsp[-3].addr));
	}
break;
case 25:
#line 259 "parse.y"
{
		struct router *r;

		if ((r = router_find(&yyvsp[-2].addr)) == NULL) {
			yyerror("Unknown router %s", addr_ntoa(&yyvsp[-2].addr));
			break;
		}
		if (router_add_link(r, &yyvsp[0].addr) == -1)
			yyerror("Could not add link %s", addr_ntoa(&yyvsp[0].addr));
	}
break;
case 26:
#line 270 "parse.y"
{ yyval.number = 1; }
break;
case 27:
#line 271 "parse.y"
{ yyval.number = 0; }
break;
case 28:
#line 273 "parse.y"
{ yyval.fragp = FRAG_DROP; }
break;
case 29:
#line 274 "parse.y"
{ yyval.fragp = FRAG_OLD; }
break;
case 30:
#line 275 "parse.y"
{ yyval.fragp = FRAG_NEW; }
break;
case 31:
#line 278 "parse.y"
{
		char src[20];
		snprintf(src, sizeof(src), "%d.%d.%d.%d",
		    yyvsp[-6].number, yyvsp[-4].number, yyvsp[-2].number, yyvsp[0].number);
		if (addr_pton(src, &yyval.addr) < 0)
			yyerror("Illegal IP address %s", src);
	}
break;
case 32:
#line 287 "parse.y"
{
		char src[25];
		snprintf(src, sizeof(src), "%s/%d",
		    addr_ntoa(&yyvsp[-2].addr), yyvsp[0].number);
		if (addr_pton(src, &yyval.addr) < 0)
			yyerror("Illegal IP network %s", src);
	}
break;
case 33:
#line 296 "parse.y"
{
		if (curtype == -1) {
			yyerror("Bad port type");
			break;
		}
		yyval.ai = cmd_proxy_getinfo(addr_ntoa(&yyvsp[-2].addr), curtype, yyvsp[0].number);
		curtype = -1;
		if (yyval.ai == NULL)
			yyerror("Illegal IP address port pair");
	}
break;
case 34:
#line 308 "parse.y"
{
		
		yyval.action.action = yyvsp[0].string;
		yyval.action.status = PORT_OPEN;
	}
break;
case 35:
#line 314 "parse.y"
{
		yyvsp[0].string[strlen(yyvsp[0].string) - 1] = '\0';
		if ((yyval.action.action = strdup(yyvsp[0].string + 1)) == NULL)
			yyerror("Out of memory");
		yyval.action.status = PORT_OPEN;
		free(yyvsp[0].string);
	}
break;
case 36:
#line 322 "parse.y"
{
		yyval.action.status = PORT_PROXY;
		yyval.action.action = NULL;
		yyval.action.aitop = yyvsp[0].ai;
	}
break;
case 37:
#line 328 "parse.y"
{
		yyval.action.status = PORT_PROXY;
		yyval.action.action = NULL;
		yyval.action.aitop = NULL;
		if (yyvsp[-2].string[0] != '$') {
			if (curtype == -1) {
				yyerror("Bad port type");
				break;
			}
			yyval.action.aitop = cmd_proxy_getinfo(yyvsp[-2].string, curtype, yyvsp[0].number);
			curtype = -1;
			if (yyval.action.aitop == NULL)
				yyerror("Illegal host name in proxy");
		} else {
			char proxy[1024];

			snprintf(proxy, sizeof(proxy), "%s:%d", yyvsp[-2].string, yyvsp[0].number);
			yyval.action.action = strdup(proxy);
			if (yyval.action.action == NULL)
				yyerror("Out of memory");
		}
		free(yyvsp[-2].string);
	}
break;
case 38:
#line 352 "parse.y"
{
		char proxy[1024];
		yyval.action.status = PORT_PROXY;
		yyval.action.action = NULL;
		yyval.action.aitop = NULL;

		snprintf(proxy, sizeof(proxy), "%s:%s", yyvsp[-2].string, yyvsp[0].string);
		yyval.action.action = strdup(proxy);
		if (yyval.action.action == NULL)
				yyerror("Out of memory");
		free(yyvsp[-2].string);
		free(yyvsp[0].string);
	}
break;
case 39:
#line 366 "parse.y"
{
		yyval.action.status = PORT_BLOCK;
		yyval.action.action = NULL;
	}
break;
case 40:
#line 371 "parse.y"
{
		yyval.action.status = PORT_RESET;
		yyval.action.action = NULL;
	}
break;
case 41:
#line 376 "parse.y"
{
		yyval.action.status = PORT_OPEN;
		yyval.action.action = NULL;
	}
break;
case 42:
#line 383 "parse.y"
{
		yyval.tmpl = template_find(yyvsp[0].string);
		if (yyval.tmpl == NULL)
			yyerror("Unknown template \"%s\"", yyvsp[0].string);
		free(yyvsp[0].string);
	}
break;
case 43:
#line 390 "parse.y"
{
		yyval.tmpl = template_find("default");
		if (yyval.tmpl == NULL)
			yyerror("Unknown template \"%s\"", "default");
	}
break;
case 44:
#line 396 "parse.y"
{
		yyval.tmpl = template_find(addr_ntoa(&yyvsp[0].addr));
		if (yyval.tmpl == NULL)
			yyerror("Unknown template \"%s\"", addr_ntoa(&yyvsp[0].addr));
	}
break;
case 45:
#line 403 "parse.y"
{
		yyvsp[0].string[strlen(yyvsp[0].string) - 1] = '\0';
		yyval.pers = personality_find(yyvsp[0].string+1);
		if (yyval.pers == NULL)
			yyerror("Unknown personality \"%s\"", yyvsp[0].string+1);
		free(yyvsp[0].string);
	}
break;
case 46:
#line 411 "parse.y"
{
		yyval.pers = personality_random();
		if (yyval.pers == NULL)
			yyerror("Random personality failed");
	}
break;
case 47:
#line 418 "parse.y"
{
		char asc[40];

		snprintf(asc, sizeof(asc), "%d.%d", yyvsp[-2].number, yyvsp[0].number);
		yyval.floatp = atof(asc);
	}
break;
case 48:
#line 425 "parse.y"
{
		yyval.floatp = yyvsp[0].number;
	}
break;
case 49:
#line 429 "parse.y"
{ yyval.number = 0; }
break;
case 50:
#line 431 "parse.y"
{
		yyval.number = yyvsp[-1].number;
	}
break;
case 51:
#line 435 "parse.y"
{ yyval.number = 0; }
break;
case 52:
#line 437 "parse.y"
{
		yyval.number = yyvsp[0].floatp * 100;
	}
break;
#line 994 "parse.c"
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: after reduction, shifting from state 0 to\
 state %d\n", YYPREFIX, YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("%sdebug: state %d, reading %d (%s)\n",
                        YYPREFIX, YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: after reduction, shifting from state %d \
to state %d\n", YYPREFIX, *yyssp, yystate);
#endif
    if (yyssp >= yysslim && yygrowstack())
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    return (1);
yyaccept:
    return (0);
}
