/* -/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/
 . Copyright (c) 2003 Michael Davis <mike@datanerds.net>
 . All rights reserved.
 .
 . Redistribution and use in source and binary forms, with or without
 . modification, are permitted provided that the following conditions
 . are met:
 .
 . 1. Redistributions of source code must retain the above copyright
 .    notice, this list of conditions and the following disclaimer.
 .
 . 2. Redistributions in binary form must reproduce the above copyright
 .    notice, this list of conditions and the following disclaimer in the
 .    documentation and/or other materials provided with the distribution.
 .
 . 3. The name of author may not be used to endorse or promote products
 .    derived from this software without specific prior written permission.
 .
 . THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
 . INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 . AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 . THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 . EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 . PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 . OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 . WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 . OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 . ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 . -\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\ */

#include <windows.h>
#include <stdio.h>
#include <time.h>
#include "syslog.h"

#define TBUF_LEN        2048
#define FMT_LEN         1024
#define INTERNALLOG     LOG_ERR|LOG_CONS|LOG_PERROR|LOG_PID

static int      LogFile = -1;           /* fd for log */
static int      opened;                 /* have done openlog() */
static int      LogStat = 0;            /* status bits, set by openlog() */
static char *LogTag = NULL;       /* string to tag the entry with */
static int      LogFacility = LOG_USER; /* default facility code */
static int      LogMask = 0xff;         /* mask of priorities to be logged */
extern int debug;
void syslog(int pri, char *fmt, ...)
{
        va_list ap;
        va_start(ap, fmt);
        vsyslog(pri, fmt, ap);
        va_end(ap);
}

void vsyslog(int pri, char *fmt, va_list ap){
	char ch, *p, *t;
	int tbuf_left, fmt_left, prlen, saved_errno;
	char tbuf[TBUF_LEN], fmt_cpy[FMT_LEN];

	p = tbuf;
	tbuf_left = TBUF_LEN;

	saved_errno = errno;

        /*
         * We wouldn't need this mess if printf handled %m, or if
         * strerror() had been invented before syslog().
         */
        for (t = fmt_cpy, fmt_left = FMT_LEN; (ch = *fmt); ++fmt) {
                if (ch == '%' && fmt[1] == 'm') {
                        ++fmt;
                        prlen = _snprintf(t, fmt_left, "%s",
                            strerror(saved_errno));
                        if (prlen >= fmt_left)
                                prlen = fmt_left - 1;
                        t += prlen;
                        fmt_left -= prlen;
                } else {
                        if (fmt_left > 1) {
                                *t++ = ch;
                                fmt_left--;
                        }
                }
        }
        *t = '\0';

	_vsnprintf(p, tbuf_left, fmt_cpy, ap);
	
	/* Get connected, output the message to the local logger. */
	if(opened)
		if(debug)
			printf("%s\n", p);

	return;
}

void openlog(char *ident, int logstat, int logfac){

	if(ident != NULL){
		LogTag = ident;
        LogStat = logstat;
		if (logfac != 0 && (logfac &~ LOG_FACMASK) == 0)
                LogFacility = logfac;
	}
	opened = 1;
}

void closelog()
{
  opened = 0;
}
