package varex;

import java.util.*;
import java.io.IOException;

/**
 * The class VariableString maintains a string value.
 * 
 * @author Wim Mees 
 * @version 0.1
 */
public class VariableString
    extends Variable
{
    // instance variables
    private String value = null;
    private boolean valid = false;

    /**
     * Constructor for objects of class VariableString
     */
    private VariableString(String name)
    {
        super(name);
    }

    /**
     * The method "get" returns the value of the integer
     * as a String.
     * 
     */
    public String get()
    {
        // precondition assertions
        assert valid;
    
        // convert the integer value to a string
        return value;
    }
    
    /**
     * The method "set" sets the value of the Variable
     * from a String. 
     * 
     * It always succeeds.
     * 
     * @param   stringValue String containing the value to be set
     * @return  true
     */
    public boolean set(String stringValue)
    {
        // precondition assertions
        assert stringValue!=null;
        
        value = stringValue;
        valid = true;
        
        return valid;
    }
    
    public boolean set(VariableReader variableReader) throws IOException
    {
        return set(variableReader.getString());
    }
    
    /**
     * The method "getValue" returns the value of the String
     * as a String.
     * 
     */
    String getValue()
    {
        // precondition assertions
        assert valid;
       
        return value;
    }
    
    /**
     * ----------------------------------------
     * class variables and functions
     * ----------------------------------------
    */
   
    public static VariableString create(String name)
    {
        // precondition assertions
        assert name!=null;
    
        // create a VariableString instance
        VariableString variable = new VariableString(name);
        
        // add it to the collection of variables
        addVariable(variable);
        
        // postcondition assertions
        assert variable!=null;
        
        return variable;
    }
}
