package varex;

import java.io.IOException;

/**
 * The interface VariableSpec defines the operations 
 * that a variable must offer to the "put" and "get" 
 * operations.
 * 
 * @author Wim Mees 
 * @version 0.1
 */

public interface VariableSpec
{
    /**
     * The method "get" returns the value of the Variable
     * as a String.
     * 
     */
    public String get();
    public String getName();
    
    /**
     * The method "set" sets the value of the Variable
     * from a "variable reader". 
     * 
     * It can fail when the variable reader does not contain a value 
     * of the appropriate type. This  is reported via the 
     * boolean return value.
     * 
     * @param   variableReader refers to the VariableReader object
     * @return  true when the get operation succeeded, false otherwise.
     * 
     */
    public boolean set(VariableReader variableReader) throws IOException;
    public boolean set(String stringValue);
}
