package varex;

import java.io.IOException;

/**
 * The class VariableInt maintains an integer value.
 * 
 * @author Wim Mees 
 * @version 0.1
 */
public class VariableInt
    extends Variable
{
    // instance variables
    private int value = 0;
    private boolean valid = false;

    /**
     * Constructor for objects of class VariableInt
     */
    public VariableInt(String name)
    {
        super(name);
    }

    /**
     * The method "get" returns the value of the integer
     * as a String.
     * 
     */
    public String get()
    {
        // precondition assertions
        assert valid;
    
        // convert the integer value to a string
        return String.valueOf(value);
    }
    
    private void set (int value)
    {
        this.value = value;
        this.valid = true;
    }
    
    /**
     * The method "set" sets the value of the Variable
     * from a String. 
     * 
     * It can fail when the String does not contain a value 
     * of the appropriate type. This is reported via the 
     * boolean return value.
     * 
     * @param   stringValue String containing the value to be set
     * @return  true when the get operation succeeded, false otherwise.
     */
    public boolean set(String stringValue)
    {
        // precondition assertions
        assert stringValue!=null;
        
        valid = false;
        
        // convert the parameter into an int
        try
        {
            value = Integer.parseInt(stringValue);
            valid = true;
        }
        catch(NumberFormatException e) 
        {
        }
        
        return valid;
    }
    
    public boolean set(VariableReader variableReader) throws IOException
    {
        set(variableReader.getInt());
        return true;
    }
    
    /**
     * The method "getValue" returns the value of the integer
     * as an integer.
     * 
     */
    int getValue()
    {
        // precondition assertions
        assert valid;
       
        return value;
    }          
    
   /**
     * ----------------------------------------
     * class variables and functions
     * ----------------------------------------
    */
   
    public static VariableInt create(String name)
    {
        // precondition assertions
        assert name!=null;
    
        // create a VariableInt instance
        VariableInt variable = new VariableInt(name);
        
        // add it to the collection of variables
        addVariable(variable);
        
        // postcondition assertions
        assert variable!=null;
        
        return variable;
    }
}
