package varex;

import java.util.*;
import java.io.IOException;

/**
 * The abstract class Variable defines the operations that a variable
 * must offer to the "put" and "get" operations.
 * 
 * @author Wim Mees 
 * @version 0.1
 */

public abstract class Variable
    implements VariableSpec
{
    // instance variables
    private String name = null;

    /**
     * Constructor for objects of class VariableFloat
     */
    Variable(String name)
    {
        // precondition assertions
        assert name!=null;
        
        // store name
        this.name = name;
        
        // postcondition assertions
        assert this.name!=null;
    }

    /**
     * The method "get" returns the value of the Variable
     * as a String.
     * 
     */
    abstract public String get();
    
    public String getName()
    {
        // precondition assertions
        assert name!=null;
        
        return name;
    }    
    
    /**
     * The method "set" sets the value of the Variable
     * from a String. 
     * 
     * It can fail when the String does not contain a value 
     * of the appropriate type. This  is reported via the 
     * boolean return value.
     * 
     * @param   stringValue String containing the value to be set
     * @return  true when the get operation succeeded, false otherwise.
     * 
     */
    abstract public boolean set(String stringValue);
    abstract public boolean set(VariableReader variableReader) throws IOException;
    
    /**
     * ----------------------------------------
     * class variables and functions
     * ----------------------------------------
    */
  
    // class variables
    private static Map mapOfVariables = new HashMap();
    
    static void addVariable(Variable variable)
    {
        // precondition assertions
        assert variable!=null;
        assert mapOfVariables!=null;
        
        // verify whether no other variable with this name exists already
        if (mapOfVariables.containsKey(variable.name))
        {
          // throw assertion
        }
        
        // add new variable to the map with its name as the key
        mapOfVariables.put(variable.name, variable);
    }

    public static boolean containsVariable(String variableName)
    {
        // precondition assertions
        assert variableName!=null;
        assert mapOfVariables!=null;

        return mapOfVariables.containsKey(variableName);
    }
    
    public static Variable getVariable(String variableName)
    {
        // precondition assertions
        assert variableName!=null;
        assert mapOfVariables!=null;
        
        Variable variable = (Variable) mapOfVariables.get(variableName) ;
        
        // postcondition assertions
        assert variable!=null;
        
        return variable;
    }
    
    // DEBUG
    public static void dump()
    {
        Iterator iterator = mapOfVariables.values().iterator();
        while (iterator.hasNext())
        {
            Variable variable = (Variable) iterator.next();
            
            System.out.println("variable \"" + variable.getName() + "\"");
        }
    }
    
}
