package varex;


/**
 * Abstract class ExpressionBinaryVariable - write a description of the class here
 * 
 * @author (your name here)
 * @version (version number or date here)
 */
public abstract class ExpressionBinaryVariable
    implements ExpressionSpec
{
    // instance variables
    Variable variableLeft = null;
    Variable variableRight = null;

    public ExpressionBinaryVariable(Variable variableLeft, Variable variableRight)
    {
        // precondition assertions
        assert variableLeft!=null;
        assert variableRight!=null;
        
        // store left and right expression
        this.variableLeft = variableLeft;
        this.variableRight = variableRight;
        
        // postcondition assertions
        assert this.variableLeft!=null;
        assert this.variableRight!=null;
    }
    
    /**
     * The method "evaluate" evaluates the expression 
     * and returns the result as a boolean.
     * 
     * @return  the result of evaluating the expression
     */
    public boolean evaluate()
    {
        // precondition assertions
        assert variableLeft!=null;
        assert variableRight!=null;

        if ((variableLeft instanceof VariableInt) && (variableRight instanceof VariableInt))
        {
            return evaluate (((VariableInt) variableLeft).getValue(), ((VariableInt) variableRight).getValue());
        }
        else if ((variableLeft instanceof VariableFloat) && (variableRight instanceof VariableFloat))
        {
            return evaluate (((VariableFloat) variableLeft).getValue(), ((VariableFloat) variableRight).getValue());
        }
        else if ((variableLeft instanceof VariableString) && (variableRight instanceof VariableString))
        {
            return evaluate (((VariableString) variableLeft).getValue(), ((VariableString) variableRight).getValue());
        }
        
        // no matching type combination found
        // thrown type mismatch exception
        
        // postcondition assertions
        assert false;
        
        return false;  // this line should never be reached
    }
    
    
    public abstract boolean evaluate(int valueLeft, int valueRight);
    public abstract boolean evaluate(float valueLeft, float valueRight);
    public abstract boolean evaluate(String valueLeft, String valueRight);
}
