package sops;

import java.util.Vector;

import varex.VariableSpec;

/**
 * The class OperationPutGet is an abstract superclass 
 * for the "get" and "put" operation classes.
 * 
 * It essentially provides the functionality to manage
 * a number of fields (to read/write in the put/get 
 * operation).
 * 
 * @author Wim Mees
 * @version 0.1
 */
public abstract class OperationPutGet
    extends OperationNop
{
	// instance variables
    Vector listOfFields = new Vector();

    public void addVariable (VariableSpec variable)
    {
        // precondition assertions
        assert variable!=null;
        assert listOfFields!=null;
        
        // add variable to the list
        listOfFields.add(variable);
    }
}
