package sops;

import java.io.IOException;
import varex.VariableSpec;

/**
 * The class OperationPut is a class that writes
 * a reply to a client.
 * 
 * @author Wim Mees
 * @version 0.1
 */
public class OperationPut
    extends OperationPutGet
{
    /**
     * The method "performOperation" performs
     * the operation. 
     * 
    */
    public void performOperation() throws IOException
    {
        // precondition assertions
        assert listOfFields!=null;
        assert !listOfFields.isEmpty();
        
        // first execute the commands associated with this state
        super.performOperation();

        // chain all the fields
        String result = new String("");
        for ( int i=0 ; i<listOfFields.size() ; i++ )
        {
            VariableSpec variable = (VariableSpec) listOfFields.get(i);
            result += variable.get();
        }
        
        // write out the result
        System.out.println(result);
    }
}
