package sops;

import java.util.Vector;
import java.io.IOException;

import fsm.StateOperation;

/**
 * The class OperationNop is a class that realizes
 * a "no operation" operation, in other words it does 
 * nothing.
 * 
 * It is also used as a superclass for the other
 * operations.
 * 
 * @author Wim Mees
 * @version 0.1
 */
public class OperationNop
    implements StateOperation
{
    // instance variables
    Vector listOfCommands = new Vector();

    public void addCommand (CommandSpec command)
    {
        // precondition assertions
        assert command!=null;
        assert listOfCommands!=null;
        
        // add command to the list
        listOfCommands.add(command);
    }
    
    /**
     * The method "performOperation" performs
     * the operation. 
     * 
    */
    public void performOperation() throws IOException
    {
        // default operation is to perform the commands
        // associated with this state.
        for ( int i=0 ; i<listOfCommands.size() ; i++ )
        {
            CommandSpec command = (CommandSpec) listOfCommands.get(i);
            command.execute();
        }

    }
    
    /**
     * The method "isBegin" returns true when this
     * operation indicates that the node is a "begin" node. 
     * 
     * @return  true when this is a begin node
    */
    public boolean isBegin()
    {
      // default is to return false
      return false;
    }
    
    /**
     * The method "isEnd" returns true when this
     * operation indicates that the node is an "end" node. 
     * 
     * @return  true when this is an end node
    */
    public boolean isEnd()
    {
      // default is to return false
      return false;
    }
}
