package sops;

import java.io.IOException;

import varex.VariableSpec;
import config.StdinReader;

/**
 * The class OperationGet is a class that reads
 * a request from the client.
 * 
 * @author Wim Mees
 * @version 0.1
 */
public class OperationGet
    extends OperationPutGet
{
    /**
     * The method "performOperation" performs
     * the operation. 
     * 
    */
    public void performOperation() throws IOException
    {
        // precondition assertions
        assert listOfFields!=null;
        assert !listOfFields.isEmpty();

        // first execute the commands associated with this state
        super.performOperation();

        // create an input stream from stdin
        StdinReader stdinReader = new StdinReader();
        
        // read all the specified fields
        for ( int i=0 ; i<listOfFields.size() ; i++ )
        {
            VariableSpec variable = (VariableSpec) listOfFields.get(i);
            if (! variable.set(stdinReader))
            {
                System.err.println("ERROR: set failed for variable " + variable.getName());
                assert false;
            }
        }
    }
}
