package genalg;


/**
 * The Fitness class keeps track of the fitness 
 * for a given genome.
 * 
 * @author Wim Mees
 * @version 0.1
 */
public class Fitness
{
    // instance variables
    private double value;

    /**
     * Constructor for objects of class Fitness
     */
    Fitness()
    {
        // initialise instance variables
        value = 0.5;
    }
    
    /**
     * The method "increase" is used when evidence is 
     * received that a genome fits the environment.
     * It then raises the fitness score.
     * 
     */
    void increase()
    {
        // precondition assertions
        assert ((value>=0.0) && (value<=1.0));
        
        // adapt value
        value = 0.9 * value + 0.1;
        
        // postcondition assertions
        assert ((value>=0.0) && (value<=1.0));
    }
    
    /**
     * The method "decrease" is used when evidence is 
     * received that a genome does NOT fit the environment.
     * It then lowers the fitness score.
     * 
     */
    void decrease()
    {
        // precondition assertions
        assert ((value>=0.0) && (value<=1.0));
        
        // adapt value
        value = 0.9 * value;
        
        // postcondition assertions
        assert ((value>=0.0) && (value<=1.0));
    }
    
    /**
     * The method "getFitness" the current
     * fitness value.
     * 
     * @return  the current fitness value
     */
    double getFitness()
    {
        // precondition assertions
        assert ((value>=0.0) && (value<=1.0));
        
        return value;
    }
    
    /**
     * The method main here is used for testing only.
     */
    public static void main(String [] args)
    {
        Fitness fitness = new Fitness();
        System.out.println("fitness: " + fitness.getFitness());
        
        System.out.println("-- increase fitness 5 times");
        for ( int i=0 ; i<5 ; i++ )
        {
            fitness.increase();
            System.out.println("fitness: " + fitness.getFitness());
        }
        
        System.out.println("-- decrease fitness 5 times");
        for ( int i=0 ; i<5 ; i++ )
        {
            fitness.decrease();
            System.out.println("fitness: " + fitness.getFitness());
        }
    }
}
