package genalg;

import java.util.Map;
import java.util.HashMap;

/**
 * The class EvolutionEngine manages several species.
 * 
 * @author Wim Mees
 * @version 0.1
 */
public class EvolutionEngine
{
    // class variables
    private static EvolutionEngine evolutionEngine = null;

    // instance variables
    private Map mapOfPopulations = null;

    /**
     * Constructor for objects of class EvolutionEngine
     */
    private EvolutionEngine()
    {
        // initiliase instance variables
        mapOfPopulations = new HashMap();
        
        // postconditions assertions
        assert mapOfPopulations!=null;
    }
    
    /**
     * The method "addSpecies" creates a species and 
     * adds it to the map of species.
     * 
     * @param  speciesName  name of the species
     * @param  genomeLowerBound  lower bound 
     * @param  genomeUpperBound  upper bound
     */
    public void addSpecies(String speciesName, String genomeLowerBound, String genomeUpperBound)
    {
        // preconditions assertions
        assert speciesName!=null;
        assert genomeLowerBound!=null;
        assert genomeUpperBound!=null;
        assert mapOfPopulations!=null;
        assert !mapOfPopulations.containsKey(speciesName);
        
        // create a population of this species
        Population population = new Population(100, genomeLowerBound, genomeUpperBound);

        // add this newly creates species to the map
        mapOfPopulations.put(speciesName, population);

        // postconditions assertions
        assert population!=null;
        assert mapOfPopulations.containsKey(speciesName);
    }

    /**
     * The method "getGenomeSample" returns the genome of a 
     * random individual in the population of "species".
     * 
     * @param   species defines the population
     * @return  the genome as a String
     */
    public String getGenomeSample(String species)
    {
        // precondition assertions
        assert species!=null;

        // retreive population
        Population population = (Population) mapOfPopulations.get(species);
        
        // postconditions assertions
        assert population!=null;
        
        return population.getGenomeSample();
    }
    
    /**
     * The method "genomeIsFit" increases the fitness degree
     * of a given genome in the fitness map of a given species.
     * 
     * @param   species defines the population
     * @param   genome  the genome for which to modify the fitness
     */
    public void genomeIsFit(String species, String genome)
    {
        // precondition assertions
        assert species!=null;
        assert genome!=null;
        
        // retreive population
        Population population = (Population) mapOfPopulations.get(species);
        
        // postconditions assertions
        assert population!=null;
        
        population.genomeIsFit(genome);
    }

    /**
     * The method "genomeIsNotFit" decreases the fitness degree
     * of a given genome in the fitness map of a given species.
     * 
     * @param   genome  the genome for which to modify the fitness
     */
    public void genomeIsNotFit(String species, String genome)
    {
        // precondition assertions
        assert species!=null;
        assert genome!=null;
        
        // retreive population
        Population population = (Population) mapOfPopulations.get(species);
        
        // postconditions assertions
        assert population!=null;
        
        population.genomeIsNotFit(genome);
    }
    
    /**
     * The method "getEvolutionEngine" creates an EvolutionEngine
     * objects when none existed, and returns the existing one
     * if one was created beforehand.
     * 
     * @return  a reference to an unique EvolutionEngine object
     */
    public static EvolutionEngine getEvolutionEngine()
    {
        // preconditions assertions
        // none
        
        // create an EvolutionEngine object when needed
        if (evolutionEngine==null)
        {
            evolutionEngine= new EvolutionEngine();
        }    
    
        // postconditions assertions
        assert evolutionEngine!=null;
        
        return evolutionEngine;
    }

    /**
     * The method main here is used for testing only.
     */
    public static void main(String [] args)
    {
        EvolutionEngine evolutionEngine = getEvolutionEngine();
        
        evolutionEngine.addSpecies("apes", "aaa", "fff");
        evolutionEngine.addSpecies("birds", "aaa", "fff");
        evolutionEngine.addSpecies("dogs", "aaa", "fff");
    }
        
}
