package fsm;


/**
 * The interface TransitionCondition defines the 
 * fonctionalities that the finite state machine
 * requires from a condition that is associated
 * with one of its transitions.
 * 
 * @author Wim Mees 
 * @version 0.1
 */

public interface TransitionCondition
{
    /**
     * The method "triggers" verifies whether the condition
     * associated with a certain transition is satisfied,
     * in which case the method returns "true".
     * 
     * @return  true when the condition is satisfied 
     */
    boolean triggers();
}
