package fsm;

/**
 * The class Transition models a transition of the finite
 * state machine.
 * 
 * @author Wim Mees 
 * @version 0.1
 */
public class Transition
    extends GraphElement
{
    // instance variables
    private State stateFrom = null;
    private State stateTo   = null;
    private TransitionCondition condition = null;

    /**
     * Constructor for objects of class Transition
     */
    public Transition(String label, State stateFrom, State stateTo, TransitionCondition condition, String comment)
    {
        // precondition assertions
        assert label!=null;
        assert label.trim().length()>0;
        assert stateFrom!=null;
        assert stateTo!=null;
        
        // set label in superclass
        setLabel(label);
        
        // set the comment (if any)
        if (comment!=null)
        {
            setComment(comment);
        }
        
        // initialise instance variables
        this.stateFrom = stateFrom;
        this.stateTo   = stateTo;
        this.condition = condition;
        
        // register with state "stateFrom" as an outgoing transition 
        stateFrom.registerOutgoingTransition(this);
    }

    boolean isDefault()
    {
        return condition==null;
    }

    /**
     * The method "triggers" verifies whether the condition
     * associated with this transition is satisfied,
     * in which case the method returns "true".
     * 
     * @return  true when the condition is satisfied 
     */
    boolean triggers()
    {
        // precondition assertions
        // none 
        
        // if a condition is associated with this transition,
        // evaluate it
        if (condition!=null)
        {
            return condition.triggers();
        }  
        
        // a default transition always triggers
        return true;
    }
    
    /**
     * The method "getTo" returns the destination state 
     * for this transition.
     * 
     * @return  destination state 
     */
    State getTo()
    {
        // precondition assertions
        assert stateTo!=null;
        
        return stateTo;
    }
}
