package fsm;

import java.io.IOException;

/**
 * The StateOperation interface defines the minimal operations
 * that an operation, associated with a state of the finite state
 * machine, must support.
 * 
 * @author Wim Mees 
 * @version 0.1
 */

public interface StateOperation
{
    /**
     * The method "performOperation" performs
     * the operation. 
     * 
    */
    void performOperation() throws IOException;
    
    /**
     * The method "isBegin" returns true when this
     * operation indicates that the node is a "begin" node. 
     * 
     * @return  true when this is a begin node
    */
    boolean isBegin();
    
    /**
     * The method "isEnd" returns true when this
     * operation indicates that the node is an "end" node. 
     * 
     * @return  true when this is an end node
    */
    boolean isEnd();
}
