package fsm;

import java.io.IOException;

/**
 * The class StateMachine models the functioning
 * of a finite state machine.
 * 
 * @author Wim Mees 
 * @version 0.1
 */
public class StateMachine
{
    // instance variables
    // none

    /**
     * The method run operates the finite state machine.
     * 
     */
    public static void run() throws IOException
    {
        State state = State.getBeginState();
        
        do
        {
            // pre-step conditions
            assert state!=null;
        
            // follow the transition that triggers to the next state
            state = state.step();
          
            // post-step conditions
            assert state!=null;
        
        } while (! state.isEndState());
    }
}
