package config;

import java.io.*;
import varex.*;

/**
 * The class StdinReader reads from stdin and extracts
 * a value of the requested type.
 * 
 * @author Wim Mees
 * @version 0.1
 */
public class StdinReader
    implements VariableReader
{
    // instance variables - replace the example below with your own
    private StringBuffer buffer = new StringBuffer();
    private static InputStreamReader inputStreamReader = new InputStreamReader(System.in);
    private static BufferedReader bufferedReader = new BufferedReader (inputStreamReader);

    /**
     * Constructor for objects of class StdinReader
     */
    public StdinReader()
    {
        // initialise instance variables
    }

    private char getChar(int index) throws IOException
    {
        while (index >= buffer.length())
        { 
            buffer.append(bufferedReader.readLine() + '\r'); 
        }
        
        return buffer.charAt(index);
    }

    /**
     * An example of a method - replace this comment with your own
     * 
     * @param  y   a sample parameter for a method
     * @return     the sum of x and y 
     */
    public int getInt() throws IOException
    {
        // precondition assertions
        assert buffer!=null;
        
        // skip leading space
        int index =0;
        while (isSeparator(getChar(index)))
        {
            index++;
        }

        // grab all characters '0'-'9'
        int indexBefore = index;
        while ( (getChar(index) >= '0') && (getChar(index) <= '9') )
        {
            index++;
        }
        
        // convert the resulting substring to an integer value
        int value =0;
        if (index > indexBefore)
        {
            String valueString = buffer.substring(indexBefore, index);
            value = Integer.parseInt(valueString);
        }    
        else
        {
            // throw exception
        }    
        
        // remove the substring from the stringbuffer
        buffer.delete(0, index);

        // postcondition assertions
        // none
        
        return value;
    }

    public float getFloat() throws IOException
    {
        // precondition assertions
        assert buffer!=null;
        
        // skip leading space
        int index =0;
        while (isSeparator(getChar(index)))
        {
            index++;
        }

        // grab all characters '0'-'9' before the decimal point
        int indexBefore = index;
        while ( (getChar(index) >= '0') && (getChar(index) <= '9') )
        {
            index++;
        }

        // check if there is a decimal point present
        if ( (getChar(index) == '.') || (getChar(index) == ',') )
        {
            index++;
        }
        else
        {
            // throw exception
        }    

        // grab all characters '0'-'9' behind the decimal point
        while ( (getChar(index) >= '0') && (getChar(index) <= '9') )
        {
            index++;
        }
        
        // convert the resulting substring to a floating point value
        float value =0;
        if (index > indexBefore)
        {
            String valueString = buffer.substring(indexBefore, index);
            value = Float.parseFloat(valueString);
        }    
        else
        {
            // throw exception
        }    
        
        // remove the substring from the stringbuffer
        buffer.delete(0, index);

        // postcondition assertions
        // none
        
        return value;
    }
    
    public String getString() throws IOException
    {
        // precondition assertions
        assert buffer!=null;
        
        // skip leading space
        int index =0;
        while (isSeparator(getChar(index)))
        {
            index++;
        }

        // check if the next character is a '"'
        int indexBefore = index;
        String value;
        if (getChar(index) == '"')
        {
            // step in the string
            index++;
            
            // read until the next '"'
            while (getChar(index) != '"')
            {
                index++;
            }

            // extract the string value
            if (indexBefore+1 < index-1)
            {
                value = buffer.substring(indexBefore+1, index-1);
            }
            else
            {
                value = new String("");
            }
        }
        else
        {
            // read until the next space or a carriage return
            while ( (getChar(index) != ' ') && (getChar(index) != '\r') )
            {
                index++;
            }
            
            // extract the string value
            value = buffer.substring(indexBefore, index);
        }
        
        // remove the substring from the stringbuffer
        buffer.delete(0, index);

        // postcondition assertions
        assert value!=null;
        
        return value;
    }

    private static boolean isSpace(char c)
    {
        return c == ' ';
    }
    
    private static boolean isReturn(char c)
    {
        return c == '\r';
    }

    private static boolean isSeparator(char c)
    {
        return isSpace(c) || isReturn(c);
    }

// for debugging    
    public static void main(String[] args) throws IOException
    {
        StdinReader stdinReader = new StdinReader();
        System.out.println(stdinReader.getInt());
        System.out.println(stdinReader.getFloat());
        System.out.println(stdinReader.getString());
    }
}
