package config;

import java.util.Date;

import varex.VariableSpec;
import varex.VariableReader;

/**
 * The class Macro provides access to system
 * information, to be used as fields in a put 
 * operation.
 * 
 * @author Wim Mees 
 * @version 0.1
 */
public class Macro
    implements VariableSpec
{
    // instance variables
    private String command;

    /**
     * Constructor for objects of class Macro
     */
    public Macro(String command)
    {
        // precondition assertions
        assert command!=null;
    
        // initialise instance variables
        this.command = command;
        
        // postcondition assertions
        assert this.command!=null;
    }
        
    /**
     * The method "get" returns the value that results
     * from this macro as a String.
     * 
     * @return  the value of the macro
     */
    public String get()
    {
        // precondition assertions
        assert command!=null;

        // interpret the command
        String result = null;
        if (command.compareTo("date")==0)
        {
            Date date = new Date();
            result = date.toString();
        }
        else
        {
            System.err.println("ERROR: unknown macro command \"" + command + "\"");
            assert false;
        }
        
        return result;
    }
    
    /**
     * Some methods which we have to provide in order
     * to implement the interface VariableSpec, but which
     * should never be called on a macro object.
     * 
     */
    public String getName()
    {
        assert false;
        return null;
    }    
    public boolean set(VariableReader variableReader)
    {
        assert false;
        return false;
    }    
    public boolean set(String stringValue)
    {
        assert false;
        return false;
    }    
}
