package config;


/**
 * The class CommandGenalgNoFit generates
 * a call to the evolution engine to decrease
 * the fitness degree for a given genome from 
 * a given species.
 * 
 * @author Wim Mees 
 * @version 0.1
 */
public class CommandGenalgNoFit
    extends CommandGenalg
{
    /**
     * Constructor for objects of class CommandGenalgNoFit
     */
    public CommandGenalgNoFit(String nameIndividual, String nameSpecies)
    {
        super(nameIndividual, nameSpecies);
    }

    /**
     * The method execute is called when the corresponding
     * state is activated.
     * 
     */
    public void execute()
    {
        // postcondition assertions
        assert nameIndividual!=null;
        assert nameSpecies!=null;
        assert evolutionEngine!=null;
        
        // get the sample genome
        evolutionEngine.genomeIsNotFit(nameSpecies, nameIndividual);
    }
}
