package config;

import genalg.EvolutionEngine;
import varex.Variable;

/**
 * The class CommandGenalgGenerate generates
 * a call to the evolution engine to generate
 * a genome sample from a given species.
 * 
 * @author Wim Mees 
 * @version 0.1
 */
public class CommandGenalgGenerate
    extends CommandGenalg
{
    /**
     * Constructor for objects of class CommandGenalgGenerate
     */
    public CommandGenalgGenerate(String nameIndividual, String nameSpecies)
    {
        super(nameIndividual, nameSpecies);
    }

    /**
     * The method execute is called when the corresponding
     * state is activated.
     * 
     */
    public void execute()
    {
        // postcondition assertions
        assert nameIndividual!=null;
        assert nameSpecies!=null;
        assert evolutionEngine!=null;
        
        // get the sample genome
        String genome = evolutionEngine.getGenomeSample(nameSpecies);
        
        // get the variable
        Variable variable = Variable.getVariable(nameIndividual);

        // store the genome in the variable
        variable.set(genome);
    }
}
