package config;


/**
 * The class CommandGenalgFit generates
 * a call to the evolution engine to increase
 * the fitness degree for a given genome from 
 * a given species.
 * 
 * @author Wim Mees 
 * @version 0.1
 */
public class CommandGenalgFit
    extends CommandGenalg
{
    /**
     * Constructor for objects of class CommandGenalgFit
     */
    public CommandGenalgFit(String nameIndividual, String nameSpecies)
    {
        super(nameIndividual, nameSpecies);
    }

    /**
     * The method execute is called when the corresponding
     * state is activated.
     * 
     */
    public void execute()
    {
        // postcondition assertions
        assert nameIndividual!=null;
        assert nameSpecies!=null;
        assert evolutionEngine!=null;
        
        // get the sample genome
        evolutionEngine.genomeIsFit(nameSpecies, nameIndividual);
    }
}
