package config;

import genalg.EvolutionEngine;
import sops.CommandSpec;

/**
 * The abstract class CommandGenalg provides the basic
 * tools for a command object that interact with the
 * evolution-engine object from the genalg package.
 * 
 * @author Wim Mees
 * @version 0.1
 */
public abstract class CommandGenalg
    implements CommandSpec
{
    // instance variables
    EvolutionEngine evolutionEngine = null;
    String nameIndividual = null;
    String nameSpecies = null;

    /**
     * Constructor for objects of class CommandGenalg
     */
    public CommandGenalg(String nameIndividual, String nameSpecies)
    {
        // precondition assertions
        assert nameIndividual!=null;
        assert nameSpecies!=null;
        
        // obtain a reference to the evolution engine
        evolutionEngine = EvolutionEngine.getEvolutionEngine();

        // initialise instance variables
        this.nameIndividual = nameIndividual;
        this.nameSpecies = nameSpecies;
        
        // postcondition assertions
        assert this.nameIndividual!=null;
        assert this.nameSpecies!=null;
        assert evolutionEngine!=null;
    }

    /**
     * The method execute must be provide in order 
     * to implement the "CommandSpec" interface.
     * 
     */
    public abstract void execute();
}
