/*
 * Decompiled with CFR 0.152.
 */
package genalg;

import genalg.FitnessMap;
import genalg.Individual;
import genalg.Maternity;
import java.util.List;
import java.util.Random;
import java.util.Vector;

public class Population {
    private static Random random;
    private List listOfIndividuals = null;
    private String lowerBound = null;
    private String upperBound = null;
    private FitnessMap fitnessMap = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$genalg$Population;

    public Population(int populationSize, String lowerBound, String upperBound) {
        if (!$assertionsDisabled && lowerBound == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && upperBound == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && populationSize <= 1) {
            throw new AssertionError();
        }
        this.listOfIndividuals = new Vector();
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.fitnessMap = new FitnessMap();
        int i = 0;
        while (i < populationSize) {
            Individual individual = new Individual(lowerBound, upperBound);
            this.listOfIndividuals.add(individual);
            this.fitnessMap.getFitness(individual.getGenes());
            ++i;
        }
        if (!$assertionsDisabled && this.lowerBound == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.upperBound == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.listOfIndividuals == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.listOfIndividuals.size() != populationSize) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.fitnessMap == null) {
            throw new AssertionError();
        }
    }

    public void evolve() {
        if (!$assertionsDisabled && this.listOfIndividuals == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.listOfIndividuals.size() <= 0) {
            throw new AssertionError();
        }
        int nrOfRebirth = (int)Math.round(0.3 * (double)this.listOfIndividuals.size());
        Maternity maternity = new Maternity(this.fitnessMap);
        int i = 0;
        while (i < nrOfRebirth) {
            int indexRandomIndividualThatDies = random.nextInt(this.listOfIndividuals.size());
            this.listOfIndividuals.remove(indexRandomIndividualThatDies);
            Individual newBorn = new Individual(maternity.giveBirth());
            this.listOfIndividuals.add(newBorn);
            ++i;
        }
        int nrOfMutations = (int)Math.round(0.1 * (double)this.listOfIndividuals.size());
        int i2 = 0;
        while (i2 < nrOfMutations) {
            int indexRandomIndividual = random.nextInt(this.listOfIndividuals.size());
            Individual individual = (Individual)this.listOfIndividuals.get(indexRandomIndividual);
            individual.mutate(this.lowerBound, this.upperBound);
            ++i2;
        }
        int nrOfCrossovers = (int)Math.round(0.1 * (double)this.listOfIndividuals.size());
        int i3 = 0;
        while (i3 < nrOfCrossovers) {
            int indexFirstRandomIndividual = random.nextInt(this.listOfIndividuals.size());
            int indexSecondRandomIndividual = random.nextInt(this.listOfIndividuals.size());
            Individual firstIndividual = (Individual)this.listOfIndividuals.get(indexFirstRandomIndividual);
            Individual secondIndividual = (Individual)this.listOfIndividuals.get(indexSecondRandomIndividual);
            firstIndividual.crossOver(secondIndividual);
            ++i3;
        }
    }

    String getGenomeSample() {
        if (!$assertionsDisabled && this.listOfIndividuals == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.listOfIndividuals.size() <= 0) {
            throw new AssertionError();
        }
        int indexRandomIndividual = random.nextInt(this.listOfIndividuals.size());
        Individual individual = (Individual)this.listOfIndividuals.get(indexRandomIndividual);
        String genome = individual.getGenes();
        if (!$assertionsDisabled && genome == null) {
            throw new AssertionError();
        }
        return genome;
    }

    void genomeIsFit(String genome) {
        if (!$assertionsDisabled && genome == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.fitnessMap == null) {
            throw new AssertionError();
        }
        this.fitnessMap.increaseFitness(genome);
    }

    void genomeIsNotFit(String genome) {
        if (!$assertionsDisabled && genome == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.fitnessMap == null) {
            throw new AssertionError();
        }
        this.fitnessMap.decreaseFitness(genome);
    }

    String getPopulation() {
        if (!$assertionsDisabled && this.listOfIndividuals == null) {
            throw new AssertionError();
        }
        String result = new String("");
        int i = 0;
        while (i < this.listOfIndividuals.size()) {
            Individual individual = (Individual)this.listOfIndividuals.get(i);
            result = result + individual.getGenes() + "\r\n";
            ++i;
        }
        if (!$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        return result;
    }

    public static void main(String[] args) {
        Population population = new Population(20, "0.0.0", "3.9.9");
        System.out.println("population:\r\n" + population.getPopulation());
        int i = 0;
        while (i < 10) {
            System.out.println("evolution " + i);
            population.evolve();
            System.out.println(population.getPopulation());
            ++i;
        }
        String genome = population.getGenomeSample();
        System.out.println("random genome: " + genome);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$genalg$Population == null ? (class$genalg$Population = Population.class$("genalg.Population")) : class$genalg$Population).desiredAssertionStatus();
        random = new Random();
    }
}

