/*
 * Decompiled with CFR 0.152.
 */
package config;

import config.CommandGenalg;
import config.CommandGenalgFit;
import config.CommandGenalgGenerate;
import config.CommandGenalgNoFit;
import config.Macro;
import fsm.State;
import fsm.Transition;
import fsm.TransitionCondition;
import genalg.EvolutionEngine;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import sops.CommandSpec;
import sops.OperationBegin;
import sops.OperationEnd;
import sops.OperationGet;
import sops.OperationNop;
import sops.OperationPut;
import sops.OperationPutGet;
import varex.ExpressionBinaryBooleanAnd;
import varex.ExpressionBinaryBooleanOr;
import varex.ExpressionBinaryVariableEqual;
import varex.ExpressionBinaryVariableGreaterThan;
import varex.ExpressionBinaryVariableLessThan;
import varex.ExpressionSpec;
import varex.ExpressionUnaryBoolean;
import varex.TransitionConditionExpression;
import varex.Variable;
import varex.VariableFloat;
import varex.VariableInt;
import varex.VariableString;

public class ConfigParser {
    private static int constantCounter;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$config$ConfigParser;

    public ConfigParser() throws ParserConfigurationException, SAXException, IOException {
        this("gmhoney.xml");
    }

    public ConfigParser(String filename) throws ParserConfigurationException, SAXException, IOException {
        if (!$assertionsDisabled && filename == null) {
            throw new AssertionError();
        }
        this.parseFile(filename);
    }

    private void parseFile(String filename) throws ParserConfigurationException, SAXException, IOException {
        if (!$assertionsDisabled && filename == null) {
            throw new AssertionError();
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new File(filename));
        NodeList nodeList = document.getElementsByTagName(new String("fsm"));
        if (!$assertionsDisabled && nodeList.getLength() != 1) {
            throw new AssertionError();
        }
        Node nodeFsm = nodeList.item(0);
        if (!$assertionsDisabled && nodeFsm == null) {
            throw new AssertionError();
        }
        this.parseFsm(nodeFsm);
    }

    private void parseFsm(Node nodeFsm) {
        if (!$assertionsDisabled && nodeFsm == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !nodeFsm.hasChildNodes()) {
            throw new AssertionError();
        }
        NodeList nodeListChildren = nodeFsm.getChildNodes();
        int i = 0;
        while (i < nodeListChildren.getLength()) {
            Node nodeChild = nodeListChildren.item(i);
            if (nodeChild.getNodeType() == 1) {
                if (nodeChild.getNodeName().compareTo("state") == 0) {
                    this.parseState(nodeChild);
                } else if (nodeChild.getNodeName().compareTo("transition") == 0) {
                    this.parseTransition(nodeChild);
                } else if (nodeChild.getNodeName().compareTo("constant") == 0) {
                    this.parseConstant(nodeChild);
                } else {
                    System.err.println("ERROR: fsm contains unknown child \"" + nodeChild.getNodeName() + "\"");
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
            }
            ++i;
        }
    }

    private void parseState(Node nodeState) {
        if (!$assertionsDisabled && nodeState == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !nodeState.hasChildNodes()) {
            throw new AssertionError();
        }
        String label = null;
        OperationNop stateOperation = null;
        String comment = null;
        Vector<CommandSpec> vectorCommands = new Vector<CommandSpec>();
        NodeList nodeListChildren = nodeState.getChildNodes();
        int i = 0;
        while (i < nodeListChildren.getLength()) {
            Node nodeChild = nodeListChildren.item(i);
            if (nodeChild.getNodeType() == 1) {
                if (nodeChild.getNodeName().compareTo("label") == 0) {
                    label = this.parsePcdata(nodeChild);
                } else if (nodeChild.getNodeName().compareTo("species") == 0) {
                    this.parseStateSpecies(nodeChild);
                } else if (nodeChild.getNodeName().compareTo("individual") == 0) {
                    vectorCommands.add(this.parseStateIndividual(nodeChild));
                } else if (nodeChild.getNodeName().compareTo("operation") == 0) {
                    stateOperation = this.parseStateOperation(nodeChild);
                } else if (nodeChild.getNodeName().compareTo("constant") == 0) {
                    System.err.println("ERROR: constants are not yet supported");
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                } else if (nodeChild.getNodeName().compareTo("comment") == 0) {
                    comment = this.parsePcdata(nodeChild);
                } else {
                    System.err.println("ERROR: state contains unknown child \"" + nodeChild.getNodeName() + "\"");
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
            }
            ++i;
        }
        if (!$assertionsDisabled && stateOperation == null) {
            throw new AssertionError();
        }
        int i2 = 0;
        while (i2 < vectorCommands.size()) {
            stateOperation.addCommand((CommandSpec)vectorCommands.get(i2));
            ++i2;
        }
        if (!$assertionsDisabled && label == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && stateOperation == null) {
            throw new AssertionError();
        }
        State state = State.createState(label, stateOperation, comment);
    }

    private void parseStateSpecies(Node nodeStateSpecies) {
        if (!$assertionsDisabled && nodeStateSpecies == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !nodeStateSpecies.hasChildNodes()) {
            throw new AssertionError();
        }
        EvolutionEngine evolutionEngine = EvolutionEngine.getEvolutionEngine();
        String label = null;
        String action_type = null;
        String lowerBound = null;
        String upperBound = null;
        NodeList nodeListChildren = nodeStateSpecies.getChildNodes();
        int i = 0;
        while (i < nodeListChildren.getLength()) {
            Node nodeChild = nodeListChildren.item(i);
            if (nodeChild.getNodeType() == 1) {
                if (nodeChild.getNodeName().compareTo("label") == 0) {
                    label = this.parsePcdata(nodeChild);
                } else if (nodeChild.getNodeName().compareTo("action") == 0) {
                    NamedNodeMap mapOfAttributes;
                    Node nodeAttributeType;
                    if (!nodeChild.hasAttributes()) {
                        System.err.println("ERROR: state/species attributes missing for action");
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                    if ((nodeAttributeType = (mapOfAttributes = nodeChild.getAttributes()).getNamedItem("type")) == null) {
                        System.err.println("ERROR: state/species attribute \"type\" missing in put/get");
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                    action_type = nodeAttributeType.getNodeValue();
                } else if (nodeChild.getNodeName().compareTo("lowerbound") == 0) {
                    lowerBound = this.parsePcdata(nodeChild);
                } else if (nodeChild.getNodeName().compareTo("upperbound") == 0) {
                    upperBound = this.parsePcdata(nodeChild);
                } else {
                    System.err.println("ERROR: state/species contains unknown child \"" + nodeChild.getNodeName() + "\"");
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
            }
            ++i;
        }
        if (!$assertionsDisabled && label == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && action_type == null) {
            throw new AssertionError();
        }
        if (action_type.compareTo("load") == 0) {
            if (!$assertionsDisabled && lowerBound == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && upperBound == null) {
                throw new AssertionError();
            }
            evolutionEngine.addSpecies(label, lowerBound, upperBound);
        } else {
            System.err.println("ERROR: state/species contains unknown action type \"" + action_type + "\"");
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
    }

    private CommandSpec parseStateIndividual(Node nodeStateIndividual) {
        if (!$assertionsDisabled && nodeStateIndividual == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !nodeStateIndividual.hasChildNodes()) {
            throw new AssertionError();
        }
        EvolutionEngine evolutionEngine = EvolutionEngine.getEvolutionEngine();
        String label = null;
        String species_label = null;
        String action_type = null;
        NodeList nodeListChildren = nodeStateIndividual.getChildNodes();
        int i = 0;
        while (i < nodeListChildren.getLength()) {
            Node nodeChild = nodeListChildren.item(i);
            if (nodeChild.getNodeType() == 1) {
                if (nodeChild.getNodeName().compareTo("label") == 0) {
                    label = this.parsePcdata(nodeChild);
                } else if (nodeChild.getNodeName().compareTo("species_label") == 0) {
                    species_label = this.parsePcdata(nodeChild);
                } else if (nodeChild.getNodeName().compareTo("action") == 0) {
                    NamedNodeMap mapOfAttributes;
                    Node nodeAttributeType;
                    if (!nodeChild.hasAttributes()) {
                        System.err.println("ERROR: state/individual attributes missing for action");
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                    if ((nodeAttributeType = (mapOfAttributes = nodeChild.getAttributes()).getNamedItem("type")) == null) {
                        System.err.println("ERROR: state/individual attribute \"type\" missing in put/get");
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                    action_type = nodeAttributeType.getNodeValue();
                } else {
                    System.err.println("ERROR: state/individual contains unknown child \"" + nodeChild.getNodeName() + "\"");
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
            }
            ++i;
        }
        if (!$assertionsDisabled && label == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && species_label == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && action_type == null) {
            throw new AssertionError();
        }
        CommandGenalg command = null;
        if (action_type.compareTo("generate") == 0) {
            VariableString.create(label);
            command = new CommandGenalgGenerate(label, species_label);
        } else if (action_type.compareTo("fit") == 0) {
            command = new CommandGenalgFit(label, species_label);
        } else if (action_type.compareTo("nofit") == 0) {
            command = new CommandGenalgNoFit(label, species_label);
        } else {
            System.err.println("ERROR: state/individual contains unknown action type \"" + action_type + "\"");
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
        if (!$assertionsDisabled && command == null) {
            throw new AssertionError();
        }
        return command;
    }

    private OperationNop parseStateOperation(Node nodeStateOperation) {
        if (!$assertionsDisabled && nodeStateOperation == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !nodeStateOperation.hasChildNodes()) {
            throw new AssertionError();
        }
        OperationNop stateOperation = null;
        NodeList nodeListChildren = nodeStateOperation.getChildNodes();
        int i = 0;
        while (i < nodeListChildren.getLength()) {
            Node nodeChild = nodeListChildren.item(i);
            if (nodeChild.getNodeType() == 1) {
                OperationPutGet operationPutGet;
                if (nodeChild.getNodeName().compareTo("put") == 0) {
                    stateOperation = operationPutGet = new OperationPut();
                    this.parseStateOperationPutGet(nodeChild, operationPutGet);
                } else if (nodeChild.getNodeName().compareTo("get") == 0) {
                    stateOperation = operationPutGet = new OperationGet();
                    this.parseStateOperationPutGet(nodeChild, operationPutGet);
                } else if (nodeChild.getNodeName().compareTo("nop") == 0) {
                    stateOperation = new OperationNop();
                } else if (nodeChild.getNodeName().compareTo("begin") == 0) {
                    stateOperation = new OperationBegin();
                } else if (nodeChild.getNodeName().compareTo("end") == 0) {
                    stateOperation = new OperationEnd();
                } else {
                    System.err.println("ERROR: state/operation contains unknown child \"" + nodeChild.getNodeName() + "\"");
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
            }
            ++i;
        }
        return stateOperation;
    }

    private void parseStateOperationPutGet(Node nodeStateOperationPutGet, OperationPutGet stateOperationPutGet) {
        if (!$assertionsDisabled && nodeStateOperationPutGet == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !nodeStateOperationPutGet.hasChildNodes()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && stateOperationPutGet == null) {
            throw new AssertionError();
        }
        NodeList nodeListChildren = nodeStateOperationPutGet.getChildNodes();
        int i = 0;
        while (i < nodeListChildren.getLength()) {
            Node nodeChild = nodeListChildren.item(i);
            if (nodeChild.getNodeType() == 1) {
                if (nodeChild.getNodeName().compareTo("field") == 0) {
                    Variable variable;
                    String variableName;
                    NamedNodeMap mapOfAttributes;
                    Node nodeAttributeType;
                    if (!nodeChild.hasAttributes()) {
                        System.err.println("ERROR: state/operation attributes missing in put/get");
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                    if ((nodeAttributeType = (mapOfAttributes = nodeChild.getAttributes()).getNamedItem("type")) == null) {
                        System.err.println("ERROR: state/operation attribute \"type\" missing in put/get");
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                    if (nodeAttributeType.getNodeValue().compareTo("cstring") == 0) {
                        DecimalFormat numberFormat = new DecimalFormat("000");
                        String variableName2 = "cstring_" + numberFormat.format(++constantCounter);
                        String variableValue = this.parsePcdata(nodeChild);
                        VariableString variable2 = VariableString.create(variableName2);
                        variable2.set(variableValue);
                        stateOperationPutGet.addVariable(variable2);
                    } else if (nodeAttributeType.getNodeValue().compareTo("string") == 0) {
                        variableName = this.parsePcdata(nodeChild);
                        variable = null;
                        variable = Variable.containsVariable(variableName) ? Variable.getVariable(variableName) : VariableString.create(variableName);
                        stateOperationPutGet.addVariable(variable);
                    } else if (nodeAttributeType.getNodeValue().compareTo("int") == 0) {
                        variableName = this.parsePcdata(nodeChild);
                        variable = null;
                        variable = Variable.containsVariable(variableName) ? Variable.getVariable(variableName) : VariableInt.create(variableName);
                        stateOperationPutGet.addVariable(variable);
                    } else if (nodeAttributeType.getNodeValue().compareTo("float") == 0) {
                        variableName = this.parsePcdata(nodeChild);
                        variable = null;
                        variable = Variable.containsVariable(variableName) ? Variable.getVariable(variableName) : VariableFloat.create(variableName);
                        stateOperationPutGet.addVariable(variable);
                    } else if (nodeAttributeType.getNodeValue().compareTo("macro") == 0) {
                        String macroCommand = this.parsePcdata(nodeChild);
                        Macro macro = new Macro(macroCommand);
                        stateOperationPutGet.addVariable(macro);
                    } else if (nodeAttributeType.getNodeValue().compareTo("individual") == 0) {
                        variableName = this.parsePcdata(nodeChild);
                        variable = null;
                        if (Variable.containsVariable(variableName)) {
                            variable = Variable.getVariable(variableName);
                        } else {
                            System.err.println("ERROR: unknown individual \"" + variableName + "\"");
                            if (!$assertionsDisabled) {
                                throw new AssertionError();
                            }
                        }
                        stateOperationPutGet.addVariable(variable);
                    } else {
                        System.err.println("ERROR: state/operation unknown attribute \"" + nodeAttributeType.getNodeValue() + "\" in put/get operation");
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                } else {
                    System.err.println("ERROR: node is not \"Node.ELEMENT_NODE\"");
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
            }
            ++i;
        }
    }

    private void parseTransition(Node nodeTransition) {
        if (!$assertionsDisabled && nodeTransition == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !nodeTransition.hasChildNodes()) {
            throw new AssertionError();
        }
        String label = null;
        State stateFrom = null;
        State stateTo = null;
        TransitionCondition condition = null;
        String comment = null;
        NodeList nodeListChildren = nodeTransition.getChildNodes();
        int i = 0;
        while (i < nodeListChildren.getLength()) {
            Node nodeChild = nodeListChildren.item(i);
            if (nodeChild.getNodeType() == 1) {
                if (nodeChild.getNodeName().compareTo("label") == 0) {
                    if (!$assertionsDisabled && label != null) {
                        throw new AssertionError();
                    }
                    label = this.parsePcdata(nodeChild);
                } else if (nodeChild.getNodeName().compareTo("from") == 0) {
                    if (!$assertionsDisabled && stateFrom != null) {
                        throw new AssertionError();
                    }
                    String labelStateFrom = this.parsePcdata(nodeChild);
                    stateFrom = State.getState(labelStateFrom);
                } else if (nodeChild.getNodeName().compareTo("to") == 0) {
                    if (!$assertionsDisabled && stateTo != null) {
                        throw new AssertionError();
                    }
                    String labelStateTo = this.parsePcdata(nodeChild);
                    stateTo = State.getState(labelStateTo);
                } else if (nodeChild.getNodeName().compareTo("condition") == 0) {
                    if (!$assertionsDisabled && condition != null) {
                        throw new AssertionError();
                    }
                    condition = this.parseTransitionCondition(nodeChild);
                } else if (nodeChild.getNodeName().compareTo("comment") == 0) {
                    if (!$assertionsDisabled && comment != null) {
                        throw new AssertionError();
                    }
                    comment = this.parsePcdata(nodeChild);
                } else if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            ++i;
        }
        if (!$assertionsDisabled && label == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && stateFrom == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && stateTo == null) {
            throw new AssertionError();
        }
        new Transition(label, stateFrom, stateTo, condition, comment);
    }

    private TransitionCondition parseTransitionCondition(Node nodeCondition) {
        if (!$assertionsDisabled && nodeCondition == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !nodeCondition.hasChildNodes()) {
            throw new AssertionError();
        }
        String conditionString = this.parsePcdata(nodeCondition);
        ExpressionSpec expression = this.parseExpression(conditionString);
        TransitionConditionExpression condition = new TransitionConditionExpression(expression);
        if (!$assertionsDisabled && condition == null) {
            throw new AssertionError();
        }
        return condition;
    }

    private ExpressionSpec parseExpression(String expressionString) {
        if (!$assertionsDisabled && expressionString == null) {
            throw new AssertionError();
        }
        ExpressionSpec expression = null;
        StringTokenizer expressionStringTokenizer = new StringTokenizer(expressionString, "()<>=&|", true);
        while (expressionStringTokenizer.hasMoreTokens()) {
            String token = expressionStringTokenizer.nextToken().trim();
            if (token.compareTo("(") == 0) {
                int openCount = 1;
                String enclosedExpressionString = new String();
                while (openCount > 0) {
                    String nextToken = expressionStringTokenizer.nextToken().trim();
                    if (nextToken.compareTo("(") == 0) {
                        ++openCount;
                        continue;
                    }
                    if (nextToken.compareTo(")") == 0) {
                        --openCount;
                        continue;
                    }
                    enclosedExpressionString = enclosedExpressionString + nextToken;
                }
                ExpressionSpec expressionLeft = this.parseExpression(enclosedExpressionString);
                if (expressionStringTokenizer.hasMoreTokens()) {
                    String nextToken = expressionStringTokenizer.nextToken().trim();
                    if (nextToken.compareTo("^") == 0) {
                        expression = new ExpressionBinaryBooleanAnd(expressionLeft, this.parseExpression(expressionStringTokenizer.nextToken("")));
                        continue;
                    }
                    if (nextToken.compareTo("|") == 0) {
                        expression = new ExpressionBinaryBooleanOr(expressionLeft, this.parseExpression(expressionStringTokenizer.nextToken("")));
                        continue;
                    }
                    System.err.println("ERROR: illegal operator \"" + nextToken + "\" in expression \"" + expressionString + "\"");
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    continue;
                }
                expression = expressionLeft;
                continue;
            }
            if (token.compareTo("!") == 0) {
                expression = new ExpressionUnaryBoolean(this.parseExpression(expressionStringTokenizer.nextToken("")));
                continue;
            }
            if (Variable.containsVariable(token)) {
                Variable variableLeft = Variable.getVariable(token);
                String operatorString = expressionStringTokenizer.nextToken().trim();
                String variableRightString = expressionStringTokenizer.nextToken().trim();
                Variable variableRight = null;
                if (Variable.containsVariable(variableRightString)) {
                    variableRight = Variable.getVariable(variableRightString);
                } else {
                    DecimalFormat numberFormat = new DecimalFormat("000");
                    String variableRightName = "cstring_" + numberFormat.format(++constantCounter);
                    variableRight = VariableString.create(variableRightName);
                    variableRight.set(variableRightString);
                }
                if (operatorString.compareTo("=") == 0) {
                    expression = new ExpressionBinaryVariableEqual(variableLeft, variableRight);
                    continue;
                }
                if (operatorString.compareTo("<") == 0) {
                    expression = new ExpressionBinaryVariableLessThan(variableLeft, variableRight);
                    continue;
                }
                if (operatorString.compareTo(">") == 0) {
                    expression = new ExpressionBinaryVariableGreaterThan(variableLeft, variableRight);
                    continue;
                }
                System.err.println("ERROR: illegal operator \"" + operatorString + "\" in expression \"" + expressionString + "\"");
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                continue;
            }
            System.err.println("ERROR: illegal begin \"" + token + "\" in expression \"" + expressionString + "\"");
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
        if (!$assertionsDisabled && expression == null) {
            throw new AssertionError();
        }
        return expression;
    }

    private void parseConstant(Node nodeConstant) {
        if (!$assertionsDisabled && nodeConstant == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !nodeConstant.hasChildNodes()) {
            throw new AssertionError();
        }
        System.out.println("constant: tbd");
    }

    private String parsePcdata(Node nodePcdata) {
        if (!$assertionsDisabled && nodePcdata == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !nodePcdata.hasChildNodes()) {
            throw new AssertionError();
        }
        String value = null;
        NodeList nodeListChildren = nodePcdata.getChildNodes();
        int i = 0;
        while (i < nodeListChildren.getLength()) {
            Node nodeChild = nodeListChildren.item(i);
            if (nodeChild.getNodeType() == 3) {
                if (nodeChild.getNodeName().compareTo("#text") == 0) {
                    value = nodeChild.getNodeValue();
                } else {
                    System.out.println("error name: " + nodeChild.getNodeName());
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
            } else {
                System.out.println("error type: " + nodeChild.getNodeType());
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            ++i;
        }
        if (!$assertionsDisabled && value == null) {
            throw new AssertionError();
        }
        return value;
    }

    public static void main(String[] args) throws ParserConfigurationException, SAXException, IOException {
        new ConfigParser();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$config$ConfigParser == null ? (class$config$ConfigParser = ConfigParser.class$("config.ConfigParser")) : class$config$ConfigParser).desiredAssertionStatus();
        constantCounter = 0;
    }
}

