/**
 *	Copyright (c) 2003, Andrew B. Smith and Jason M. Fox
 *	All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 *	modification, are permitted provided that the following conditions are met:
 *
 *	* Redistributions of source code must retain the above copyright notice, 
 *	  this list of conditions and the following disclaimer.
 *	* Redistributions in binary form must reproduce the above copyright notice, 
 *	  this list of conditions and the following disclaimer in the documentation 
 *	  and/or other materials provided with the distribution.
 *	* Neither the name of the CERIAS nor the names of its contributors 
 *	  may be used to endorse or promote products derived from this software without 
 *	  specific prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 *	ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 *	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 *	IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 *	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 *	BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 *	DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
 *	OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 *	OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
 *	OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * The Service class is basically a structure for different honeyd perl scripts
 */

public class Service {

    private String _serviceName;	// name of the fingerprint
    private float  _percentage;		// percentage of hosts to use this service on
    private int _port;             // port number of service
    private String _proto;        // protocol
	
    /**
     * The Service constructor takes a name and percentage as argument
     *
     * @param	name	name of the service
     * @param	percentage	percent of hosts to use this service
     * @param   port
     * @param   proto
     */
    public Service(String name, float percentage, int port, String proto) {
        _serviceName = name;
        _port = port;
        _proto = proto;
    }
	
    /**
     * returns the name of the service
     *
     * @return the name of the service
     */
    public String getServiceName() {
        return _serviceName;
    }
	
    /**
     * gives the percentage of time a host should use this service
     *
     * @return	percentage this service is to be used
     */
    public float getPercentage() {
        return _percentage;
    } 

    public int getPort() {
        return _port;
    }

    public String getProtocol() {
        return _proto;
    }
}
