/**
 *	Copyright (c) 2003, Andrew B. Smith and Jason M. Fox
 *	All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 *	modification, are permitted provided that the following conditions are met:
 *
 *	* Redistributions of source code must retain the above copyright notice, 
 *	  this list of conditions and the following disclaimer.
 *	* Redistributions in binary form must reproduce the above copyright notice, 
 *	  this list of conditions and the following disclaimer in the documentation 
 *	  and/or other materials provided with the distribution.
 *	* Neither the name of the CERIAS nor the names of its contributors 
 *	  may be used to endorse or promote products derived from this software without 
 *	  specific prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 *	ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 *	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 *	IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 *	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 *	BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 *	DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
 *	OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 *	OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
 *	OF THE POSSIBILITY OF SUCH DAMAGE.
 */
 
import java.net.InetAddress;
import java.io.*;
import java.util.StringTokenizer;
 

/* RandomNet is a simple tool to generate a random network for the honeyd tool.
 *  Settings can be placed in a "RandomNet configuration" file that specify 
 *  number of routers, number of layers, which nmap fingerprints to use
 *  , etc.  RandomNet provides a gui for creating this configuration file, or it 
 *  can be edited by hand. 
 *
 * @author Andrew B. Smith
 * @author Jason M. Fox
 * @version %I%, %G%
 * @since 0.0
 */
class RandomNet {
	
    /**
     * The main method of the program. We parse the simple command line arguments
     * and then create an instance of the MiddleClass to read in the RandomNet
     * configuration file and handle the gui/generation 
     * 
     * @param	args	the incoming arguments: see usage information
     */
    public static void main(String[] args) {
		
        // Check for the correct number of arguments or help flag
        for (int i = 0; i < args.length; i++) {
            if (args[i].equals("--help")) {
                printUsage();
            }
        }
		
        // Declare option variables
        boolean enableGuiMode = false;					// Default to console mode
        String randomNetConfigFilename = "./rn.conf"; 	// Filename of template 
        String honeydConfigFilename = "./config.random";// name of honeyd config file
		
        // Load arguments
        for (int i = 0; i < args.length; i++) {
            if (args[i].equals("-g")) {
                enableGuiMode = true;
            } else if (args[i].equals("-f")) {
                randomNetConfigFilename = args[++i];
            } else if (args[i].equals("-o")) {
                honeydConfigFilename = args[++i];
            }
        }
		
        // Create middle class
        MiddleClass mediator = new MiddleClass(randomNetConfigFilename,
                honeydConfigFilename, enableGuiMode);
		
    }
	
    /**
     * Prints the usage information to the screen and exits
     */
    public static void printUsage() {
        System.out.println("usage:  RandomNet [-g] [-f randomnet_configfile] "
                + " [-o honeyd_config_file]");
        System.out.println("\n\tOPTIONS:\n");
        System.out.println("\t\t-g\tenable gui-mode (default is console mode)\n");
        System.out.println("\t\t-f\tload specified RandomNet config file "
                + "(default is ./rn.conf)\n");
        System.out.println("\t\t-o\tname of honeyd config file to generate "
                + "(default is ./config.random)\n");
        System.exit(0);
    } 
	 
}
 
