/**
 *	Copyright (c) 2003, Andrew B. Smith and Jason M. Fox
 *	All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 *	modification, are permitted provided that the following conditions are met:
 *
 *	* Redistributions of source code must retain the above copyright notice, 
 *	  this list of conditions and the following disclaimer.
 *	* Redistributions in binary form must reproduce the above copyright notice, 
 *	  this list of conditions and the following disclaimer in the documentation 
 *	  and/or other materials provided with the distribution.
 *	* Neither the name of the CERIAS nor the names of its contributors 
 *	  may be used to endorse or promote products derived from this software without 
 *	  specific prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 *	ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 *	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 *	IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 *	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 *	BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 *	DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
 *	OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 *	OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
 *	OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * The Fingerprint class is basically a structure for holding nmap fingerprints
 */

public class Fingerprint {

    /**
     * name of the fingerprint
     */
    private String _fingerprintName;
	
    /**
     * number of this fingerprint in the _availableFingerprints array
     * in <code>MiddleClass</code>
     */
    private int _myId; 
	
    /**
     * The Fingerprint default constructor takes a name 
     * and id as argument
     *
     * @param	name	name of the fingerprint
     * @param	id		id of this fingerprint in the MiddleClass
     */
    public Fingerprint(String name, int id) {
        _fingerprintName = name.trim();
        _myId = id;
    }

    /**
     * returns the name of the fingerprint
     *
     * @return the name of the fingerprint
     */
    public String getFingerprintName() {
        return _fingerprintName;
    }
	
    /**
     * @return id of the fingerprint
     */
    public int getId() {
        return _myId;
    } 
	
    /**
     * for output in the gui, this overloads toString() to output the fingerprint
     * name
     * 
     * @return fingerprint name
     */
    public String toString() {
        return _fingerprintName;
    } 
	
}
