/*
 * Copyright 2003 Thomas KIEFFER <tomkif@hotmail.lu>
 * All rights reserved.
 *
 * Copyright 2003 CSRRT-LU (http://www.csrrt.org.lu)
 * All right reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Niels Provos.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 *used to store (draw and mouse react) virtual host property
 *like list of SET, ADD
 *name 
 *bind IP
 */ 



import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;

class VirtualHostVisual extends Component implements MouseListener, MouseMotionListener
{
	//variable used to set up the graphical representation
	private int coordX=0;
	private int coordY=0;
	private int width=130;
	private int height=45;
	private JFrame parent;//parent container for drawing
	private VirtualHostNetwork vhn;//Hosts super container
	
	//variable used to configure Virtual Host
	private static int hostNumber=0;//number of virtual host in the network
	private String name;//name of the host
	private String ipAddress="0.0.0.0";//IP address of the Host
	private Vector addProps;//list of ADD property
	private Vector setProps;//list of SET property
	private Vector link;//list of linked Host
	private int nbrAddRule=0;//number of ADD rules
	private int nbrSetRule=0;//number of SET rules
	
	
	//variable used for mouse action
	private boolean selected=false;//if selected or not
	private boolean draged=false;//if draged or not
	
	private boolean isRouter=false;//if is a router or not
	
	
	
	/**********************************************************/
	/***************Constructor********************************/
	public VirtualHostVisual(String name,String ip)
	{
		this.name=name;
		this.ipAddress=ip;
		this.hostNumber++;
		addProps=new Vector();
		setProps=new Vector();
		link=new Vector();
	}
	
	public VirtualHostVisual(String name)
	{
		this.name=name;
		this.hostNumber++;
		addProps=new Vector();
		setProps=new Vector();
		link=new Vector();
	}
	
	public VirtualHostVisual()
	{
		this.hostNumber++;
		addProps=new Vector();
		setProps=new Vector();
		link=new Vector();
	}
	
	public VirtualHostVisual(String name,String ip,int x, int y)
	{
		this.name=name;
		this.ipAddress=ip;
		this.hostNumber++;
		addProps=new Vector();
		setProps=new Vector();
		link=new Vector();
		coordX=x;
		coordY=y;
	}
	
	public VirtualHostVisual(String name,int x, int y)
	{
		this.name=name;
		this.hostNumber++;
		addProps=new Vector();
		setProps=new Vector();
		link=new Vector();
		coordX=x;
		coordY=y;
	}
	
	public VirtualHostVisual(int x, int y)
	{
		this.hostNumber++;
		addProps=new Vector();
		setProps=new Vector();
		link=new Vector();
		coordX=x;
		coordY=y;
	}


		
	/***************************************************/
	/***************Mouse Action************************/
	public void mouseDragged(MouseEvent e) 
	{	
		if(draged==true)
 		{
 			if((this.getX()+e.getX()>=vhn.getX() && this.getX()+e.getX()+this.width<=vhn.getX()+vhn.getWidth())&&this.getY()+e.getY()>=vhn.getY()&&this.getY()+e.getY()+this.height<=vhn.getY()+vhn.getHeight())
 			{
 				this.move(this.getX()+e.getX(),this.getY()+e.getY());
 				parent.repaint();
 			}
 		}
	}

 	public void mouseMoved(MouseEvent e) 
 	{	
 	}
 

	public void mouseClicked(MouseEvent e) 
	{
		if(e.getButton()==e.BUTTON3)
		{
			new PropertyList(this).show(true);
		}
	}

 	public void mouseEntered(MouseEvent e) 
 	{
 	}

 	public void mouseExited(MouseEvent e) 
 	{
 	}

 	public void mousePressed(MouseEvent e) 
 	{
 		if(e.getButton()!=e.BUTTON3)
 		{ 
 			draged=true;
 		}
 		selected=true;
 		parent.repaint();
 	}

 	public void mouseReleased(MouseEvent e) 
 	{
 		if(e.getButton()!=e.BUTTON3)
 		{
 			if((this.getX()+e.getX()>=vhn.getX() && this.getX()+e.getX()+this.width<=vhn.getX()+vhn.getWidth())&&this.getY()+e.getY()>=vhn.getY()&&this.getY()+e.getY()+this.height<=vhn.getY()+vhn.getHeight())
 			{
    			this.move(this.getX()+e.getX(),this.getY()+e.getY());
    		}
    	}
    	selected=false;
    	draged=false;
    	parent.repaint();
    	
 	}
	/***************************************************/
	/*****************internal Action*******************/
	public void paint(Graphics g)
	{
		if(selected==true)
			g.setColor(new Color(255,0,0));
		else if(isRouter==true)
			g.setColor(new Color(50,150,50));
		else
			g.setColor(new Color(0,0,0));
		g.drawRect(coordX,coordY,width,height);
		g.drawString(this.getName(),coordX+5,coordY+20);
		g.drawString(this.getIP(),coordX+5,coordY+40);
	}
	
	
	public void move(int x, int y)
	{
		coordX=x;
		coordY=y;
		this.setBounds(coordX,coordY,width,height);
	}
	
	
	public Dimension getDim()
	{
		return new Dimension(width,height);
	}
	
	public int getX()
	{
		return coordX;
	}
	
	public int getY()
	{
		return coordY;
	}
	
	public void setIP(String ip)
	{
		this.ipAddress=ip;
	}
	
	public void addParent(HostNetConf c)
	{
		
		parent =  c;
		c.getContentPane().add(this);
		this.setBounds(coordX,coordY,width,height);
		this.addMouseListener(this);
		this.addMouseMotionListener(this);
	}
	
	
	public Vector getAddProp()
	{
		return addProps;
	}
	
	public Vector getSetProp()
	{
		return setProps;
	}
	
	public String getName()
	{
		return this.name;
	}
	
	public String getIP()
	{
		return this.ipAddress;
	}
	
	public AddProp getAddProp(int i)
	{
		return ((AddProp)(addProps.get(i)));
	}
	
	public SetProp getSetProp(int i)
	{
		return ((SetProp)(setProps.get(i)));
	}
	
	public void removeAddProps(AddProp a)
	{
		nbrAddRule--;
		addProps.remove(a);
	}
	
	public void removeSetProps(SetProp a)
	{
		nbrSetRule--;
		setProps.remove(a);
	}
	
	public void removeAddProps(int i)
	{
		nbrAddRule--;
		addProps.remove(i);
	}
	
	public void removeSetProps(int i)
	{
		nbrSetRule--;
		setProps.remove(i);
	}
	
	public void addAddProps(AddProp a)
	{
		nbrAddRule++;
		addProps.add(a);
	}
	
	public void addSetProps(SetProp s)
	{
		nbrSetRule++;
		setProps.add(s);
	}
	
	public int nbrAddRules()
	{
		return nbrAddRule;
	}
	
	public int nbrSetRules()
	{
		return nbrSetRule;
	}
	
		public boolean getIsRouter()
	{
		return isRouter;
	}
	
	public void setIsRouter(boolean is)
	{
		isRouter=is;
	}
	
	public void setVirtualNetwork(VirtualHostNetwork v)
	{
		vhn=v;
		if(vhn==null)
			System.out.println("v==null");
	}
	
	/***************************************************/
	/*************extraction methods********************/
	public String bind()
	{
		if(this.name.compareTo(this.ipAddress)==0)
			return "";
		return new String("bind "+this.ipAddress+" "+this.name+"\n");
	}
	
	public String extractAddRules(int i)
	{
		if(i>=addProps.size())
			return "";
			
		if(this.name.compareTo(this.ipAddress)==0)
			return "";
			
		String tmp;
		if(((AddProp)addProps.get(i)).getAction().compareToIgnoreCase(new String("proxy"))==0)
		{
			tmp="add "+this.name+" "+((AddProp)addProps.get(i)).getProto()+" port "+((AddProp)addProps.get(i)).getPort()+" "+((AddProp)addProps.get(i)).getAction()+" "+((AddProp)addProps.get(i)).getCmd()+"";
		}
		else if(((AddProp)addProps.get(i)).getAction().compareToIgnoreCase(new String("cmd-string"))==0)
		{
			tmp="add "+this.name+" "+((AddProp)addProps.get(i)).getProto()+" port "+((AddProp)addProps.get(i)).getPort()+" \""+((AddProp)addProps.get(i)).getCmd()+"\"";	
		}
		else
		{
			tmp="add "+this.name+" "+((AddProp)addProps.get(i)).getProto()+" port "+((AddProp)addProps.get(i)).getPort()+" "+((AddProp)addProps.get(i)).getAction();
		}
		return tmp;
	}
	
	public String extractSetRules(int i)
	{
		if(i>=setProps.size())
			return "";
			
		if(this.name.compareTo(this.ipAddress)==0)
			return "";
		 	
		String tmp;
		if(((SetProp)setProps.get(i)).getProperty().compareToIgnoreCase(new String("personality"))==0)
		{
			tmp="set "+this.name+" "+((SetProp)setProps.get(i)).getProperty()+" "+((SetProp)setProps.get(i)).getProto()+" \""+((SetProp)setProps.get(i)).getCmd1()+" \""+((SetProp)setProps.get(i)).getCmd2();
		}
		else if(((SetProp)setProps.get(i)).getProperty().compareToIgnoreCase(new String("personality random"))==0)
		{
			tmp="set "+this.name+" "+((SetProp)setProps.get(i)).getProperty();
		}
		else if(((SetProp)setProps.get(i)).getProperty().compareToIgnoreCase(new String("uid gid"))==0)
		{
			tmp="set "+this.name+" uid "+((SetProp)setProps.get(i)).getCmd1()+" gid "+((SetProp)setProps.get(i)).getCmd2();
		}
		else if(((SetProp)setProps.get(i)).getProperty().compareToIgnoreCase(new String("ip-uptime"))==0)
		{
			tmp="set "+this.ipAddress+" uptime "+((SetProp)setProps.get(i)).getCmd1();
		}
		else
		{
			tmp="set "+this.name+" "+((SetProp)setProps.get(i)).getProperty()+" "+((SetProp)setProps.get(i)).getCmd1();
		}
		return tmp;
	}
 
}
