/*
 * Copyright 2003 Thomas KIEFFER <tomkif@hotmail.lu>
 * All rights reserved.
 *
 * Copyright 2003 CSRRT-LU (http://www.csrrt.org.lu)
 * All right reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Niels Provos.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/*
 *VirtualHostNetwork
 *use to handle all element in the virtual
 *network like host,routing and link
 */


import java.util.*;
import java.awt.*;
import javax.swing.*;

class VirtualHostNetwork 
{
	private Vector vhvV;//list of Virtual host
	private Vector nLink;//list of link
	private Vector net;//list of routing property
	private HostNetConf parent;//parent Frame 
	private int x=0;//bounding of the network
	private int y=0;//
	private int width=0;//
	private int height=0;//
	
	
	
	
	/***********************************************/
	/*************Constructor***********************/
	public VirtualHostNetwork()
	{
		vhvV=new Vector();
		nLink=new Vector();
		net=new Vector();
	}
	
	public VirtualHostNetwork(VirtualHostVisual v, HostNetConf p,int x,int y,int w, int h)
	{
		parent=p;
		this.x=x;
		this.y=y;
		this.width=w;
		this.height=h;
		vhvV=new Vector();
		nLink=new Vector();
		net=new Vector();
		v.move(this.x,this.y);
		vhvV.add(v);
	}
	
	public VirtualHostNetwork(HostNetConf p,int x,int y, int w, int h)
	{
		parent=p;
		this.x=x;
		this.y=y;
		this.width=w;
		this.height=h;
		vhvV=new Vector();
		nLink=new Vector();
		net=new Vector();
	}
	
	
	/************************************************/
	/*************Internal opperation****************/
	
	//method used to paint graphicaly on the parent Fram all host and link 
	public void repaint(Graphics g)
	{
		for(int i=0;i<vhvV.size();i++)
		{
			((VirtualHostVisual)vhvV.get(i)).paint(g);
		}
		for(int j=0;j<nLink.size();j++)
		{
			((NetworkLink)nLink.get(j)).paint(g);
		}
	}
	
	
	public void setRestictZone(int x,int y,int w,int h)
	{
		this.x=x;
		this.y=y;
		this.width=w;
		this.height=h;
	}
	
	public int getNbHost()
	{
		return vhvV.size();
	}
	
	public int getNbLink()
	{
		return nLink.size();
	}
	
	public int getX()
	{
		return x;
	}
	
	public int getY()
	{
		return y;
	}
	
	public int getWidth()
	{
		return width;
	}
	
	public int getHeight()
	{
		return height;
	}
	
	public int getNbNetwork()
	{
		return net.size();
	}
	
	public Vector getHost()
	{
		return this.vhvV;
	}
	
	public Vector getNetwork()
	{
		return this.net;
	}
	
	public HostNetConf getParent()
	{
		return parent;
	}
	public VirtualHostVisual getVirtualHost(int i)
	{
		return (VirtualHostVisual)vhvV.get(i);
	}
	
	public Network getNetwork(int i)
	{
		return (Network)net.get(i);
	}
	
	//used to create the new links when a net routing property is added
	private void generateLink()
	{
		int v1=-1;
		int v2=-1;
		nLink.clear();
		if(net.size()==0)
			return;
		for(int j=0;j<net.size();j++)
		{
			v1=-1;v2=-1;
			if(((Network)net.get(j)).getProperty().compareTo("add net")==0)
			{
				for(int i=0;i<vhvV.size();i++)
				{
					if(((VirtualHostVisual)vhvV.get(i)).getIP().compareTo(((Network)net.get(j)).getIP1())==0)
					{
						v1=i;
					}
					else if(((VirtualHostVisual)vhvV.get(i)).getIP().compareTo(((Network)net.get(j)).getIP2())==0)
					{
						v2=i;
					}
					if(v1!=-1 && v2!=-1)
						break;
				}
				if(v1!=-1 && v2!=-1)
				{
					this.addLink((VirtualHostVisual)vhvV.get(v1),(VirtualHostVisual)vhvV.get(v2));
					((VirtualHostVisual)vhvV.get(v1)).setIsRouter(true);
					
				}
				//cover the ip range to generate the links 
				//OR just generate a not generated host with name the IPRange
			}
			else if(((Network)net.get(j)).getProperty().compareTo("link")==0)
			{
				for(int i=0;i<vhvV.size();i++)
				{
					if(((VirtualHostVisual)vhvV.get(i)).getIP().compareTo(((Network)net.get(j)).getIP1())==0)
					{
						v1=i;
					}
					else if(((VirtualHostVisual)vhvV.get(i)).getIP().compareTo(((Network)net.get(j)).getIPRange())==0)
					{
						v2=i;
					}
	
					if(v1!=-1 && v2!=-1)
						break;
				}
				if(v2==-1)
				{
					VirtualHostVisual tmp =new VirtualHostVisual(((Network)net.get(j)).getIPRange(),((Network)net.get(j)).getIPRange());
					this.addHost(tmp);
					this.addLink((VirtualHostVisual)vhvV.get(v1),tmp);
					((VirtualHostVisual)vhvV.get(v1)).setIsRouter(true);
				}
				else if(v1!=-1 && v2!=-1)
				{
					this.addLink((VirtualHostVisual)vhvV.get(v1),(VirtualHostVisual)vhvV.get(v2));
					((VirtualHostVisual)vhvV.get(v1)).setIsRouter(true);
				}
			}
		}
	}
	
	
	
	public void addNetwork(Network n)
	{
		net.add(n);
		generateLink();
	}
	
	public void addLink(VirtualHostVisual v1,VirtualHostVisual v2)
	{
		nLink.add(new NetworkLink(v1,v2));
	}
	
	public void removeLink(NetworkLink n)
	{
		nLink.remove(n);
	}
	
	public void removeLink(int i)
	{
		nLink.remove(i);
	}
	
	public void addHost(VirtualHostVisual v)
	{
		
		v.move(this.x+10,this.y+10);
		v.addParent(parent);
		v.setVirtualNetwork(this);
		vhvV.add(v);
		generateLink();
	}

	public void removeHost(VirtualHostVisual v)
	{
		int i=vhvV.indexOf(v);
		int k=net.size();
		int j=0;
		while(j<k)
		{
			if(((Network)net.get(j)).getIP1().compareTo(((VirtualHostVisual)vhvV.get(i)).getIP())==0)
			{
				removeNetwork((Network)net.get(j));
			}
			else if(((Network)net.get(j)).getIP2().compareTo(((VirtualHostVisual)vhvV.get(i)).getIP())==0)
			{
				removeNetwork((Network)net.get(j));
			}
			else
				j++;
			if(k>net.size())
					k=net.size();
		}
		vhvV.remove(v);
		generateLink();
	}
	
	public void removeHost(int i)
	{
		if(i<vhvV.size())
		{
			int k=net.size();
			int j=0;
			while(j<k)
			{
				if(((Network)net.get(j)).getIP1().compareTo(((VirtualHostVisual)vhvV.get(i)).getIP())==0)
				{
					removeNetwork((Network)net.get(j));
				}
				else if(((Network)net.get(j)).getIP2().compareTo(((VirtualHostVisual)vhvV.get(i)).getIP())==0)
				{
					removeNetwork((Network)net.get(j));
				}
				else 
					j++;
				if(k>net.size())
					k=net.size();
			}
			vhvV.remove(i);
			generateLink();
		}
			
	}
	public void removeNetwork(Network n)
	{
		int i=net.indexOf(n);
		if(((Network)net.get(i)).getProperty().compareTo("link")==0)
		{
			for(int j=0;j<vhvV.size();j++)
			{
				if(((VirtualHostVisual)vhvV.get(j)).getIP().compareTo(((Network)net.get(i)).getIPRange())==0)
				{
					vhvV.remove((VirtualHostVisual)vhvV.get(j));
					break;
				}
			}
			for(int j=0;j<vhvV.size();j++)
			{
				if(((VirtualHostVisual)vhvV.get(j)).getIP().compareTo(((Network)net.get(i)).getIP1())==0)
				{
					((VirtualHostVisual)vhvV.get(j)).setIsRouter(false);
				}
			}
		}
		else
		{
			for(int j=0;j<vhvV.size();j++)
			{
				if(((VirtualHostVisual)vhvV.get(j)).getIP().compareTo(((Network)net.get(i)).getIP1())==0)
				{
					((VirtualHostVisual)vhvV.get(j)).setIsRouter(false);
				}
			}
		}
		
		net.remove(i);
		generateLink();
	}
	
	public void removeNetwork(int i)
	{
		if(i<net.size())
		{
			if(((Network)net.get(i)).getProperty().compareTo("link")==0)
			{
				for(int j=0;j<vhvV.size();j++)
				{
					if(((VirtualHostVisual)vhvV.get(j)).getIP().compareTo(((Network)net.get(i)).getIPRange())==0)
					{
						vhvV.remove((VirtualHostVisual)vhvV.get(j));
						break;
					}
				}
				for(int j=0;j<vhvV.size();j++)
				{
					if(((VirtualHostVisual)vhvV.get(j)).getIP().compareTo(((Network)net.get(i)).getIP1())==0)
					{
						((VirtualHostVisual)vhvV.get(j)).setIsRouter(false);
					}
				}
			}
			else
			{
				for(int j=0;j<vhvV.size();j++)
				{
					if(((VirtualHostVisual)vhvV.get(j)).getIP().compareTo(((Network)net.get(i)).getIP1())==0)
					{
						((VirtualHostVisual)vhvV.get(j)).setIsRouter(false);
					}
				}
			}
			net.remove(i);
			generateLink();
		}
	}
}
