/*
 * Copyright 2003 Thomas KIEFFER <tomkif@hotmail.lu>
 * All rights reserved.
 *
 * Copyright 2003 CSRRT-LU (http://www.csrrt.org.lu)
 * All right reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Niels Provos.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/**
 *GUI used to configure the starting option 
 *for honeyd
 */
public class StartConf extends javax.swing.JFrame {
    
    /** Creates new form StartConf */
    public StartConf() {
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     */
    private void initComponents() {
        jLabel1 = new javax.swing.JLabel();
        jSeparator1 = new javax.swing.JSeparator();
        daemon = new javax.swing.JCheckBox();
        polling = new javax.swing.JCheckBox();
        logFile = new javax.swing.JCheckBox();
        fingerprint = new javax.swing.JCheckBox();
        xprobe = new javax.swing.JCheckBox();
        assoc = new javax.swing.JCheckBox();
        file = new javax.swing.JCheckBox();
        iface = new javax.swing.JCheckBox();
        logfileName = new javax.swing.JTextField();
        assocFile = new javax.swing.JTextField();
        fingerFileName = new javax.swing.JTextField();
        configFileName = new javax.swing.JTextField();
        xprobeFile = new javax.swing.JTextField();
        interfaceList = new javax.swing.JTextField();
        start = new javax.swing.JButton();
        cancel = new javax.swing.JButton();
		fName=new FileName();
		
        getContentPane().setLayout(null);

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                //exitForm(evt);
                dispose();
            }
        });

        jLabel1.setFont(new java.awt.Font("Dialog", 1, 18));
        jLabel1.setText("Startup configuration");
        getContentPane().add(jLabel1);
        jLabel1.setBounds(20, 10, 240, 24);

        getContentPane().add(jSeparator1);
        jSeparator1.setBounds(20, 40, 520, 2);

        daemon.setText("Not daemonize");
        daemon.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                daemonItemStateChanged(evt);
            }
        });

        getContentPane().add(daemon);
        daemon.setBounds(30, 60, 130, 24);

        polling.setText("Polling");
        polling.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                pollingItemStateChanged(evt);
            }
        });

        getContentPane().add(polling);
        polling.setBounds(30, 90, 80, 24);

        logFile.setText("Log file");
        logFile.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                logFileItemStateChanged(evt);
            }
        });

        getContentPane().add(logFile);
        logFile.setBounds(210, 60, 100, 24);

        fingerprint.setText("fingerprints");
        fingerprint.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                fingerprintItemStateChanged(evt);
            }
        });

        getContentPane().add(fingerprint);
        fingerprint.setBounds(210, 90, 110, 24);

        xprobe.setText("xprobe");
        xprobe.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                xprobeItemStateChanged(evt);
            }
        });

        getContentPane().add(xprobe);
        xprobe.setBounds(30, 120, 80, 24);
        
        xprobeFile.setText("//");
        getContentPane().add(xprobeFile);
        xprobeFile.setBounds(120, 120, 80, 20);

        assoc.setText("associate xprob with nmap");
        assoc.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                assocItemStateChanged(evt);
            }
        });

        getContentPane().add(assoc);
        assoc.setBounds(30, 150, 200, 24);

        file.setText("config file");
        file.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                fileItemStateChanged(evt);
            }
        });

        getContentPane().add(file);
        file.setBounds(210, 120, 100, 24);

        iface.setText("interface");
        iface.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                ifaceItemStateChanged(evt);
            }
        });

        getContentPane().add(iface);
        iface.setBounds(30, 180, 90, 24);

        logfileName.setText("/var/log/honeyd.log");
        getContentPane().add(logfileName);
        logfileName.setBounds(320, 60, 220, 20);

        fingerFileName.setText("/usr/share/nmap/fingerprint");
        getContentPane().add(fingerFileName);
        fingerFileName.setBounds(320, 90, 220, 20);

		assocFile.setText("//");
		getContentPane().add(assocFile);
		assocFile.setBounds(230, 150, 220, 20);
		/******************************************/

        configFileName.setText("/home/honeyd.conf");
        getContentPane().add(configFileName);
        configFileName.setBounds(320, 120, 220, 20);

        interfaceList.setText("eth0, eth1");
        getContentPane().add(interfaceList);
        interfaceList.setBounds(130, 180, 190, 20);

        start.setText("Start");
        start.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                startActionPerformed(evt);
            }
        });

        getContentPane().add(start);
        start.setBounds(340, 220, 81, 26);

        cancel.setText("Cancel");
        cancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelActionPerformed(evt);
            }
        });

        getContentPane().add(cancel);
        cancel.setBounds(430, 220, 90, 26);

        pack();
        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setSize(new java.awt.Dimension(600, 296));
        setLocation((screenSize.width-600)/2,(screenSize.height-296)/2);
    }
	/**********************************************************************/
	/**********************************************************************/
    private void fileItemStateChanged(java.awt.event.ItemEvent evt) {
    	if (evt.getStateChange() == java.awt.event.ItemEvent.SELECTED)
    		useFile=true;
    	else
    		useFile=false;
    }

    private void fingerprintItemStateChanged(java.awt.event.ItemEvent evt) {
    	if (evt.getStateChange() == java.awt.event.ItemEvent.SELECTED)
    		useFinger=true;
    	else
    		useFinger=false;
    }

    private void logFileItemStateChanged(java.awt.event.ItemEvent evt) {
    	if (evt.getStateChange() == java.awt.event.ItemEvent.SELECTED)
    		useLogFile=true;
    	else
    		useLogFile=false;
    }

    private void ifaceItemStateChanged(java.awt.event.ItemEvent evt) {
    	if (evt.getStateChange() == java.awt.event.ItemEvent.SELECTED)
    		useIface=true;
    	else
    		useIface=false;
    }

    private void assocItemStateChanged(java.awt.event.ItemEvent evt) {
    	if (evt.getStateChange() == java.awt.event.ItemEvent.SELECTED)
    		useAssoc=true;
    	else
    		useAssoc=false;
    }

    private void xprobeItemStateChanged(java.awt.event.ItemEvent evt) {
    	if (evt.getStateChange() == java.awt.event.ItemEvent.SELECTED)
    		useXprobe=true;
    	else
    		useXprobe=false;
    }

    private void pollingItemStateChanged(java.awt.event.ItemEvent evt) {
    	if (evt.getStateChange() == java.awt.event.ItemEvent.SELECTED)
    		usePolling=true;
    	else
    		usePolling=false;
    }

    private void daemonItemStateChanged(java.awt.event.ItemEvent evt) {
    	if (evt.getStateChange() == java.awt.event.ItemEvent.SELECTED)
        	useDaemon=true;
        else
        	useDaemon=false;
    }

    private void cancelActionPerformed(java.awt.event.ActionEvent evt) {
        useDaemon=false;
    	usePolling=false;
    	useAssoc=false;
    	useFile=false;
    	useIface=false;
    	useLogFile=false;
    	useXprobe=false;
    	useFinger=false;
    	dispose();
    }

    private void startActionPerformed(java.awt.event.ActionEvent evt) {
    	StringBuffer execPath=new StringBuffer(fName.getExecPath());
    	String[] str=new String[8];
    	int k=0;
 
        if(useDaemon)
        {
        	execPath.append(" -d");
        	str[k]="-d";
        	k++;
        }
        if(usePolling)
        {
        	execPath.append(" -P");
        	str[k]="-P";
        	k++;
        }
        if(useLogFile)
        {
        	execPath.append(" -l "+logfileName.getText());
        	str[k]="-l "+logfileName.getText();
        	k++;
        	
        }
        if(useFinger)
        {
        	execPath.append(" -p "+fingerFileName.getText());
        	str[k]="-p "+fingerFileName.getText();
        	k++;
        }
        if(useXprobe)
        {
        	execPath.append(" -x "+xprobeFile.getText());
        	str[k]=" -x "+xprobeFile.getText();
        	k++;
        }
        if(useAssoc)
        {
        	execPath.append(" -a "+assocFile.getText());
        	str[k]="-a "+assocFile.getText();
        	k++;
        }
        if(useFile)
    	{
        	execPath.append(" -f "+configFileName.getText());
        	str[k]="-f "+configFileName.getText();
        	k++;
        }
        if(useIface)
   		{
        	execPath.append(" -i "+interfaceList.getText());
        	str[k]="-i "+interfaceList.getText();
        	k++;
        }
        	
        System.out.println(execPath.toString());
        String[] arg=new String[k];
        for(int i=0;i<k;i++)
        {
        	arg[k]=str[k];
        }
        	
        try
        {
        	Runtime r=Runtime.getRuntime();
        	r.exec(fName.getExecPath(),arg);
    	}
    	catch(java.io.IOException e)
    	{        		
    		javax.swing.JOptionPane jop = new javax.swing.JOptionPane();
        	jop.showMessageDialog(null,e.getMessage(),"Error", javax.swing.JOptionPane.ERROR_MESSAGE);
 
    	}
    }
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {
        dispose();    }

    // Variables declaration - do not modify
    private javax.swing.JTextField interfaceList;
    private javax.swing.JTextField assocFile;
    private javax.swing.JTextField xprobeFile;
    private javax.swing.JCheckBox polling;
    private javax.swing.JButton start;
    private javax.swing.JCheckBox assoc;
    private javax.swing.JCheckBox file;
    private javax.swing.JCheckBox iface;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JTextField fingerFileName;
    private javax.swing.JCheckBox daemon;
    private javax.swing.JButton cancel;
    private javax.swing.JTextField logfileName;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JCheckBox logFile;
    private javax.swing.JCheckBox xprobe;
    private javax.swing.JCheckBox fingerprint;
    private javax.swing.JTextField configFileName;
    // End of variables declaration
    //----------------------------------------
    //DATA
    private FileName fName;
    private boolean useDaemon=false;
    private boolean usePolling=false;
    private boolean useAssoc=false;
    private boolean useFile=false;
    private boolean useIface=false;
    private boolean useLogFile=false;
    private boolean useXprobe=false;
    private boolean useFinger=false;
    
}
