/*
 * Copyright 2003 Thomas KIEFFER <tomkif@hotmail.lu>
 * All rights reserved.
 *
 * Copyright 2003 CSRRT-LU (http://www.csrrt.org.lu)
 * All right reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Niels Provos.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/*
 *used to store the SET rules for a host
 */

class SetProp {

	private String property;
	private String proto;
	private String cmd1;
	private String cmd2;

	public SetProp(String property,String proto,String cmd1,String cmd2)
	{
		this.proto=proto;
		this.property=property;
		this.cmd1=cmd1;
		this.cmd2=cmd2;
	}
	/**
     * Return the value of the protocol (TCP,UDP,ICMP)
     * member.
     * @return protocol
     */
	public String getProto()
	{
		return proto;
	}
	/**
	 *Return the propriety (default, personality, personality random,
	 *subsystem, uptime, droprate in, uid gid, ip-uptime)
	 *of the set attribute
	 */
	public String getProperty()
	{
		return property;
	}
	/**
	 *Return the value of the command 1
	 *use as parameter for the propriety
	 */
	public String getCmd1()
	{
		return cmd1;
	}
	/**
	 *Return the value of the command 2
	 *use as parameter for the propriety
	 */
	public String getCmd2()
	{
		return cmd2;
	}
	/**
	 *Return a simple representation of the "set" rule
	 */
	public String toString()
	{
		return new String(property+","+proto+","+cmd1+","+cmd2);
	}
}

