/*
 * Copyright 2003 Thomas KIEFFER <tomkif@hotmail.lu>
 * All rights reserved.
 *
 * Copyright 2003 CSRRT-LU (http://www.csrrt.org.lu)
 * All right reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Niels Provos.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */



/*
 *
 *this gui is used to configure the routing property
 *with all option entry, link, add net
 */

public class RouteConf extends javax.swing.JFrame  {
    
    /** Creates new form RouteConf */
    public RouteConf() {
        initComponents();
    }
    
    public RouteConf(VirtualHostNetwork vhn) {
    	vhn1=vhn;
        initComponents();
    }
    
   	//methode used to create gui componet and related event and set up them
    private void initComponents() {
        jLabel1 = new javax.swing.JLabel();
        jSeparator1 = new javax.swing.JSeparator();
        hostList = new javax.swing.JComboBox();
        jLabel2 = new javax.swing.JLabel();
        addRouter = new javax.swing.JButton();
        entryList = new javax.swing.JComboBox();
        addEntry = new javax.swing.JButton();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        addressRange = new javax.swing.JTextField();
        jSeparator2 = new javax.swing.JSeparator();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        parentRList = new javax.swing.JComboBox();
        jLabel7 = new javax.swing.JLabel();
        latency = new javax.swing.JTextField();
        jLabel8 = new javax.swing.JLabel();
        loss = new javax.swing.JTextField();
        jSeparator3 = new javax.swing.JSeparator();
        jLabel9 = new javax.swing.JLabel();
        jLabel10 = new javax.swing.JLabel();
        routerList = new javax.swing.JComboBox();
        jLabel11 = new javax.swing.JLabel();
        addressRangeLink = new javax.swing.JTextField();
        addLink = new javax.swing.JButton();
        routeBrowse = new javax.swing.JButton();
        linkBrowse = new javax.swing.JButton();
        ok = new javax.swing.JButton();
        cancel = new javax.swing.JButton();

        getContentPane().setLayout(null);

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        jLabel1.setFont(new java.awt.Font("Dialog", 1, 18));
        jLabel1.setText("Routing configuration");
        getContentPane().add(jLabel1);
        jLabel1.setBounds(10, 10, 250, 30);

        getContentPane().add(jSeparator1);
        jSeparator1.setBounds(10, 40, 560, 2);


		String [] str1=new String[vhn1.getNbHost()];
		int nb=0;
		for(int i=0;i<vhn1.getNbHost();i++)
		{
			if(((VirtualHostVisual)vhn1.getVirtualHost(i)).getIP().compareTo(((VirtualHostVisual)vhn1.getVirtualHost(i)).getName())!=0)
			{
				str1[nb]=((VirtualHostVisual)vhn1.getVirtualHost(i)).getIP();
				nb++;
			}
		}
		String [] str=new String[nb];
		for(int i=0;i<nb;i++)
		{
			str[i]=str1[i];
		}
		
        hostList.setModel(new javax.swing.DefaultComboBoxModel(str));
        getContentPane().add(hostList);
        hostList.setBounds(80, 150, 160, 25);

        jLabel2.setText("Router selection");
        getContentPane().add(jLabel2);
        jLabel2.setBounds(10, 120, 100, 16);

        addRouter.setText("Add router");
        addRouter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addRouterActionPerformed(evt);
            }
        });

        getContentPane().add(addRouter);
        addRouter.setBounds(10, 240, 100, 26);

        entryList.setModel(new javax.swing.DefaultComboBoxModel(str));
        getContentPane().add(entryList);
        entryList.setBounds(10, 70, 160, 24);

        addEntry.setText("Validate");
        addEntry.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addEntryActionPerformed(evt);
            }
        });

        getContentPane().add(addEntry);
        addEntry.setBounds(190, 70, 100, 26);

        jLabel3.setText("Entry point");
        getContentPane().add(jLabel3);
        jLabel3.setBounds(10, 50, 150, 16);

        jLabel4.setText("Address range:");
        getContentPane().add(jLabel4);
        jLabel4.setBounds(10, 200, 90, 16);

        addressRange.setText("255.255.255.0/255");
        getContentPane().add(addressRange);
        addressRange.setBounds(120, 200, 160, 20);

        getContentPane().add(jSeparator2);
        jSeparator2.setBounds(10, 110, 560, 2);

        jLabel5.setText("Router IP:");
        getContentPane().add(jLabel5);
        jLabel5.setBounds(10, 160, 60, 16);

        jLabel6.setText("Parent router IP:");
        getContentPane().add(jLabel6);
        jLabel6.setBounds(260, 160, 100, 16);

        parentRList.setModel(new javax.swing.DefaultComboBoxModel(str));
        getContentPane().add(parentRList);
        parentRList.setBounds(370, 150, 160, 25);

        jLabel7.setText("latency:");
        getContentPane().add(jLabel7);
        jLabel7.setBounds(280, 200, 60, 16);

        latency.setText("10");
        getContentPane().add(latency);
        latency.setBounds(330, 200, 60, 20);

        jLabel8.setText("loss:");
        getContentPane().add(jLabel8);
        jLabel8.setBounds(410, 200, 27, 16);

        loss.setText("0.5");
        getContentPane().add(loss);
        loss.setBounds(440, 200, 63, 20);

        getContentPane().add(jSeparator3);
        jSeparator3.setBounds(10, 280, 560, 2);

        jLabel9.setText("Linking");
        getContentPane().add(jLabel9);
        jLabel9.setBounds(10, 290, 80, 16);

        jLabel10.setText("Router IP:");
        getContentPane().add(jLabel10);
        jLabel10.setBounds(10, 310, 70, 16);

        routerList.setModel(new javax.swing.DefaultComboBoxModel(str));
        getContentPane().add(routerList);
        routerList.setBounds(80, 310, 160, 25);

        jLabel11.setText("IP Range:");
        getContentPane().add(jLabel11);
        jLabel11.setBounds(270, 310, 90, 16);

        addressRangeLink.setText("255.255.255.0/255");
        getContentPane().add(addressRangeLink);
        addressRangeLink.setBounds(350, 310, 170, 20);

        addLink.setText("Add linking");
        addLink.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addLinkActionPerformed(evt);
            }
        });

        getContentPane().add(addLink);
        addLink.setBounds(10, 340, 100, 26);

        routeBrowse.setText("Router list");
        routeBrowse.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                routeBrowseActionPerformed(evt);
            }
        });

        getContentPane().add(routeBrowse);
        routeBrowse.setBounds(120, 240, 100, 26);

        linkBrowse.setText("Linking list");
        linkBrowse.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                linkBrowseActionPerformed(evt);
            }
        });

        getContentPane().add(linkBrowse);
        linkBrowse.setBounds(120, 340, 100, 26);

        ok.setText("OK");
        ok.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okActionPerformed(evt);
            }
        });

        getContentPane().add(ok);
        ok.setBounds(390, 380, 80, 26);

        cancel.setText("Cancel");
        cancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelActionPerformed(evt);
            }
        });

        getContentPane().add(cancel);
        cancel.setBounds(480, 380, 90, 26);

        pack();
        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setSize(new java.awt.Dimension(592, 439));
        setLocation((screenSize.width-592)/2,(screenSize.height-439)/2);
    }
    
	/**********************************************************/
	/*****************Internal opperation**********************/
	
    private void cancelActionPerformed(java.awt.event.ActionEvent evt) {
        this.dispose();
    }

    private void okActionPerformed(java.awt.event.ActionEvent evt) {
        this.dispose();
    }

    private void linkBrowseActionPerformed(java.awt.event.ActionEvent evt) {
        new PropertyListNetwork(vhn1).show();
    }

    private void addLinkActionPerformed(java.awt.event.ActionEvent evt) {
    	if(((String)routerList.getSelectedItem()).compareTo(this.addressRangeLink.getText())==0)
    	{
    		javax.swing.JOptionPane jop = new javax.swing.JOptionPane();
        	jop.showMessageDialog(null, "You must give a range different from the router address","Error", javax.swing.JOptionPane.ERROR_MESSAGE);
        	return;
    	}
    	if(((String)routerList.getSelectedItem()).compareTo("")==0)
    	{
    		//javax.swing.JOptionPane jop = new javax.swing.JOptionPane();
        	//jop.showMessageDialog(null, "You must give a range different from the router address","Error", javax.swing.JOptionPane.ERROR_MESSAGE);
        	return;
    	}
        vhn1.addNetwork(new Network("link",(String)routerList.getSelectedItem(),"",this.addressRangeLink.getText(),"",""));
    }

    private void routeBrowseActionPerformed(java.awt.event.ActionEvent evt) {
        new PropertyListNetwork(vhn1).show();
    }

    private void addRouterActionPerformed(java.awt.event.ActionEvent evt) {
    	if(((String)hostList.getSelectedItem()).compareTo((String)parentRList.getSelectedItem())==0)
    	{
        	javax.swing.JOptionPane jop = new javax.swing.JOptionPane();
        	jop.showMessageDialog(null, "You must give a parent router IP diffrent as the router IP","Error", javax.swing.JOptionPane.ERROR_MESSAGE);
        	return;
        }
        if(((String)hostList.getSelectedItem()).compareTo(addressRange.getText())==0 || ((String)parentRList.getSelectedItem()).compareTo(addressRange.getText())==0)
    	{
        	javax.swing.JOptionPane jop = new javax.swing.JOptionPane();
        	jop.showMessageDialog(null, "You must give a range different from the router addres","Error", javax.swing.JOptionPane.ERROR_MESSAGE);
        	return;
        }
        vhn1.addNetwork(new Network("add net",(String)hostList.getSelectedItem(),(String)parentRList.getSelectedItem(),addressRange.getText(),latency.getText(),loss.getText()));
    }

    private void addEntryActionPerformed(java.awt.event.ActionEvent evt) {
        vhn1.addNetwork(new Network("entry",(String)entryList.getSelectedItem(),"","","",""));
    }
  
    private void exitForm(java.awt.event.WindowEvent evt) {
        dispose();
    }
    
    
    // Variables declaration - do not modify
    private javax.swing.JLabel jLabel8;
    private javax.swing.JComboBox parentRList;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JTextField addressRange;
    private javax.swing.JSeparator jSeparator2;
    private javax.swing.JComboBox routerList;
    private javax.swing.JButton ok;
    private javax.swing.JTextField addressRangeLink;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JButton linkBrowse;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JButton addLink;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JButton cancel;
    private javax.swing.JButton addRouter;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JTextField loss;
    private javax.swing.JComboBox entryList;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JComboBox hostList;
    private javax.swing.JButton routeBrowse;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JTextField latency;
    private javax.swing.JButton addEntry;
    private javax.swing.JSeparator jSeparator3;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel5;
    // End of variables declaration
    //-------------------------------------
    //data
    VirtualHostNetwork vhn1;
    
}
